/*
 * Decompiled with CFR 0.152.
 */
package org.yx.util.lock;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import org.yx.exception.SumkException;
import org.yx.log.Log;
import org.yx.main.SumkServer;
import org.yx.redis.Redis;
import org.yx.redis.RedisPool;
import org.yx.util.StringUtils;
import org.yx.util.lock.Key;
import org.yx.util.lock.Lock;
import org.yx.util.lock.LockedKey;

public final class SLock {
    private static final int REDIS_LEN = 16;
    private static final String[] nodeKey = new String[16];
    private static final ThreadLocal<List<Lock>> locks;

    static Redis redis(String id) {
        int index = id.hashCode() & 0xF;
        Redis redis = RedisPool.get(nodeKey[index]);
        if (redis == null) {
            SumkException.throwException(8295462, "SLock must use in redis environment");
        }
        return redis;
    }

    private static Lock getLock(Key key) {
        List<Lock> list = locks.get();
        if (list == null || list.isEmpty() || key == null) {
            return null;
        }
        for (Lock lock : list) {
            if (!lock.getId().equals(key.getId())) continue;
            return lock;
        }
        return null;
    }

    public static void unlock() {
        List<Lock> list = locks.get();
        for (Lock lock : list) {
            lock.unlock();
        }
        locks.remove();
    }

    public static void unlock(Key key) {
        List<Lock> list = locks.get();
        if (list == null || list.isEmpty() || key == null || key == LockedKey.key) {
            return;
        }
        ListIterator<Lock> it = list.listIterator(list.size());
        while (it.hasPrevious()) {
            Lock lock = it.previous();
            if (!lock.getId().equals(key.getId())) continue;
            lock.unlock();
            it.remove();
            return;
        }
    }

    public static Key tryLock(String name, long maxWaitTime) {
        Lock lock = Lock.create(name);
        return SLock.tryLock(lock, maxWaitTime);
    }

    public static Key lock(String name) {
        return SLock.tryLock(name, Integer.MAX_VALUE);
    }

    public static Key tryLock(Lock lock, long maxWaitTime) {
        if (SLock.getLock(lock) != null) {
            return LockedKey.key;
        }
        if ((lock = lock.lock(maxWaitTime)) != null) {
            locks.get().add(lock);
        }
        return lock;
    }

    static {
        try {
            for (int i = 0; i < 16; ++i) {
                SLock.nodeKey[i] = "lock_" + i;
            }
            String script = StringUtils.load(SumkServer.class.getClassLoader().getResourceAsStream("META-INF/lua_del"));
            HashSet<Redis> set = new HashSet<Redis>();
            for (String key : nodeKey) {
                Redis redis = RedisPool.get(key);
                if (redis == null || !set.add(redis)) continue;
                redis.scriptLoad(script);
            }
        }
        catch (Exception e) {
            Log.get("sumk.lock").error("Lock init failed. Maybe you need restart!!!");
            Log.printStack(e);
        }
        locks = new ThreadLocal<List<Lock>>(){

            @Override
            protected List<Lock> initialValue() {
                return new ArrayList<Lock>(2);
            }
        };
    }
}

