/**
 * Copyright (C) 2016 - 2017 youtongluan.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * 		http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.yx.exception;

public class HttpException extends RuntimeException {

	private static final long serialVersionUID = 453453454L;
	private final Class<?> container;

	public HttpException(Class<?> container, String msg) {
		super(msg);
		this.container = container;
	}

	public HttpException(Class<?> container, String msg, Throwable exception) {
		super(msg, exception);
		this.container = container;
	}

	public static void throwException(Class<?> container, String msg) {
		throw new HttpException(container, msg);
	}

	public static void throwException(Class<?> container, String msg, Throwable exception) {
		throw new HttpException(container, msg, exception);
	}

	public Class<?> getContainer() {
		return container;
	}

}
