/**
 * Copyright (C) 2016 - 2017 youtongluan.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * 		http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.yx.exception;

import java.io.PrintWriter;
import java.io.StringWriter;

public class SoaException extends CodeBaseException {

	private static final long serialVersionUID = 453453343454L;

	private String detailError;
	private String exceptionClz;

	public String getDetailError() {
		return detailError;
	}

	public String getExceptionClz() {
		return exceptionClz;
	}

	/**
	 * 如果是bizException，就会使用bizException的code，msg
	 * 
	 * @param code
	 * @param msg
	 * @param e
	 */
	public SoaException(int code, String msg, Throwable e) {
		super(BizException.class.isInstance(e) ? e.getMessage() : msg);
		this.code = BizException.class.isInstance(e) ? ((BizException) e).getCode() : code;
		this.detailError = getException(e);
		this.exceptionClz = e == null ? "" : e.getClass().getName();
	}

	public static void throwException(int code, String msg, Throwable exception) {
		throw new SoaException(code, msg, exception);
	}

	public static void throwException(Throwable exception) {
		throw new SoaException(-1, exception.getMessage(), exception);
	}

	private static String getException(Throwable e) {
		if (e == null) {
			return "Exception is NULL";
		}
		StringWriter sw = new StringWriter();
		PrintWriter w = new PrintWriter(sw);
		e.printStackTrace(w);
		if (sw.toString().length() >= 4000) {
			return sw.toString().substring(0, 4000);
		}
		return sw.toString();
	}

}
