/**
 * Copyright (C) 2016 - 2017 youtongluan.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * 		http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.yx.http.handler;

import javax.servlet.http.HttpServletResponse;

import org.yx.http.Web;
import org.yx.http.filter.Session;

/**
 * 用来写入内容主题，是最后一个handler
 * 
 * @author 游夏
 *
 */
public class RespHeaderHandler implements HttpHandler {

	@Override
	public boolean accept(Web web) {
		return true;
	}

	@Override
	public boolean handle(WebContext ctx) throws Throwable {
		HttpServletResponse resp = ctx.getHttpResponse();
		resp.setCharacterEncoding(ctx.getCharset().name());
		String sessionID = ctx.getHeaders().get(Session.SESSIONID);
		if (sessionID != null && sessionID.length() > 0) {
			resp.setHeader(Session.SESSIONID, sessionID);
		}
		return false;
	}

}
