package org.yx.demo.member;

import java.util.Date;

import org.yx.db.annotation.Column;
import org.yx.db.annotation.ColumnType;
import org.yx.db.annotation.SoftDelete;
import org.yx.db.annotation.Table;
import org.yx.util.DateUtils;

@Table
@SoftDelete(value = "enable", columnType = Byte.class)
public class DemoUser {

	@Column(columnType = ColumnType.ID_BOTH)
	private Long id;
	private String name;
	private Integer age;
	private Date lastUpdate;

	public Date getLastUpdate() {
		return lastUpdate;
	}

	public void setLastUpdate(Date lastUpdate) {
		this.lastUpdate = lastUpdate;
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Integer getAge() {
		return age;
	}

	public void setAge(Integer age) {
		this.age = age;
	}

	@Override
	public String toString() {
		return "DemoUser [id=" + id + ", name=" + name + ", age=" + age + ", lastUpdate="
				+ DateUtils.toDateTimeString(lastUpdate) + "]";
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((age == null) ? 0 : age.hashCode());
		result = prime * result + ((id == null) ? 0 : id.hashCode());
		result = prime * result + ((name == null) ? 0 : name.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		DemoUser other = (DemoUser) obj;
		if (age == null) {
			if (other.age != null)
				return false;
		} else if (!age.equals(other.age))
			return false;
		if (id == null) {
			if (other.id != null)
				return false;
		} else if (!id.equals(other.id))
			return false;
		if (name == null) {
			if (other.name != null)
				return false;
		} else if (!name.equals(other.name))
			return false;
		return true;
	}

	

}
