/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.common.captcha;

import com.jeecms.common.web.session.SessionProvider;
import com.octo.captcha.service.CaptchaServiceException;
import com.octo.captcha.service.image.ImageCaptchaService;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class JcaptchaServlet
extends HttpServlet {
    public static final String CAPTCHA_IMAGE_FORMAT = "jpeg";
    private ImageCaptchaService captchaService;
    private SessionProvider session;

    public void init() throws ServletException {
        WebApplicationContext appCtx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        this.captchaService = (ImageCaptchaService)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)appCtx, ImageCaptchaService.class);
        this.session = (SessionProvider)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)appCtx, SessionProvider.class);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        byte[] captchaChallengeAsJpeg = null;
        ByteArrayOutputStream jpegOutputStream = new ByteArrayOutputStream();
        try {
            String captchaId = this.session.getSessionId(request, response);
            BufferedImage challenge = this.captchaService.getImageChallengeForID(captchaId, request.getLocale());
            ImageIO.write((RenderedImage)challenge, CAPTCHA_IMAGE_FORMAT, (OutputStream)jpegOutputStream);
        }
        catch (IllegalArgumentException e) {
            response.sendError(404);
            return;
        }
        catch (CaptchaServiceException e) {
            response.sendError(500);
            return;
        }
        captchaChallengeAsJpeg = jpegOutputStream.toByteArray();
        response.setHeader("Cache-Control", "no-store");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
        response.setContentType("image/jpeg");
        ServletOutputStream responseOutputStream = response.getOutputStream();
        responseOutputStream.write(captchaChallengeAsJpeg);
        responseOutputStream.flush();
        responseOutputStream.close();
    }
}

