/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.common.file;

import com.jeecms.common.image.ImageUtils;
import java.io.File;
import java.io.FileFilter;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.io.FilenameUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileWrap {
    public static final String[] EDITABLE_EXT = new String[]{"html", "htm", "css", "js", "txt"};
    private File file;
    private String rootPath;
    private FileFilter filter;
    private List<FileWrap> child;
    private String filename;

    public FileWrap(File file) {
        this(file, null);
    }

    public FileWrap(File file, String rootPath) {
        this(file, rootPath, null);
    }

    public FileWrap(File file, String rootPath, FileFilter filter) {
        this.file = file;
        this.rootPath = rootPath;
        this.filter = filter;
    }

    public static boolean editableExt(String ext) {
        ext = ext.toLowerCase(Locale.ENGLISH);
        String[] stringArray = EDITABLE_EXT;
        int n = EDITABLE_EXT.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.equals(ext)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String getName() {
        String path = this.file.getAbsolutePath();
        String relPath = path.substring(this.rootPath.length());
        return relPath.replace(File.separator, "/");
    }

    public String getPath() {
        String name = this.getName();
        return name.substring(0, name.lastIndexOf(47));
    }

    public String getFilename() {
        return this.filename != null ? this.filename : this.file.getName();
    }

    public String getExtension() {
        return FilenameUtils.getExtension((String)this.file.getName());
    }

    public long getLastModified() {
        return this.file.lastModified();
    }

    public Date getLastModifiedDate() {
        return new Timestamp(this.file.lastModified());
    }

    public long getSize() {
        return this.file.length() / 1024L + 1L;
    }

    public String getIco() {
        if (this.file.isDirectory()) {
            return "folder";
        }
        String ext = this.getExtension().toLowerCase();
        if (ext.equals("jpg") || ext.equals("jpeg")) {
            return "jpg";
        }
        if (ext.equals("png")) {
            return "png";
        }
        if (ext.equals("gif")) {
            return "gif";
        }
        if (ext.equals("html") || ext.equals("htm")) {
            return "html";
        }
        if (ext.equals("swf")) {
            return "swf";
        }
        if (ext.equals("txt")) {
            return "txt";
        }
        return "unknow";
    }

    public List<FileWrap> getChild() {
        if (this.child != null) {
            return this.child;
        }
        File[] files = this.filter == null ? this.getFile().listFiles() : this.getFile().listFiles(this.filter);
        ArrayList<FileWrap> list = new ArrayList<FileWrap>();
        if (files != null) {
            Arrays.sort(files, new FileComparator());
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                FileWrap fw = new FileWrap(f, this.rootPath, this.filter);
                list.add(fw);
                ++n2;
            }
        }
        return list;
    }

    public File getFile() {
        return this.file;
    }

    public boolean isImage() {
        if (this.isDirectory()) {
            return false;
        }
        String ext = this.getExtension();
        return ImageUtils.isValidImageExt(ext);
    }

    public boolean isEditable() {
        if (this.isDirectory()) {
            return false;
        }
        String ext = this.getExtension().toLowerCase();
        String[] stringArray = EDITABLE_EXT;
        int n = EDITABLE_EXT.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.equals(ext)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    public boolean isFile() {
        return this.file.isFile();
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setChild(List<FileWrap> child) {
        this.child = child;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FileComparator
    implements Comparator<File> {
        @Override
        public int compare(File o1, File o2) {
            if (o1.isDirectory() && !o2.isDirectory()) {
                return -1;
            }
            if (!o1.isDirectory() && o2.isDirectory()) {
                return 1;
            }
            return o1.compareTo(o2);
        }
    }
}

