/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.common.hibernate3;

import com.jeecms.common.hibernate3.HibernateSimpleDao;
import com.jeecms.common.hibernate3.Updater;
import com.jeecms.common.util.MyBeanUtils;
import java.io.Serializable;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.EntityMode;
import org.hibernate.LockMode;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.metadata.ClassMetadata;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HibernateBaseDao<T, ID extends Serializable>
extends HibernateSimpleDao {
    protected T get(ID id) {
        return this.get(id, false);
    }

    protected T get(ID id, boolean lock) {
        Object entity = lock ? this.getSession().get(this.getEntityClass(), id, LockMode.UPGRADE) : this.getSession().get(this.getEntityClass(), id);
        return (T)entity;
    }

    protected List<T> findByProperty(String property, Object value) {
        Assert.hasText((String)property);
        return this.createCriteria(new Criterion[]{Restrictions.eq((String)property, (Object)value)}).list();
    }

    protected T findUniqueByProperty(String property, Object value) {
        Assert.hasText((String)property);
        Assert.notNull((Object)value);
        return (T)this.createCriteria(new Criterion[]{Restrictions.eq((String)property, (Object)value)}).uniqueResult();
    }

    protected int countByProperty(String property, Object value) {
        Assert.hasText((String)property);
        Assert.notNull((Object)value);
        return ((Number)this.createCriteria(new Criterion[]{Restrictions.eq((String)property, (Object)value)}).setProjection(Projections.rowCount()).uniqueResult()).intValue();
    }

    protected List findByCriteria(Criterion ... criterion) {
        return this.createCriteria(criterion).list();
    }

    public T updateByUpdater(Updater<T> updater) {
        ClassMetadata cm = this.sessionFactory.getClassMetadata(this.getEntityClass());
        T bean = updater.getBean();
        Object po = this.getSession().get(this.getEntityClass(), cm.getIdentifier(bean, EntityMode.POJO));
        this.updaterCopyToPersistentObject(updater, po, cm);
        return (T)po;
    }

    private void updaterCopyToPersistentObject(Updater<T> updater, T po, ClassMetadata cm) {
        String[] propNames = cm.getPropertyNames();
        String identifierName = cm.getIdentifierPropertyName();
        T bean = updater.getBean();
        String[] stringArray = propNames;
        int n = propNames.length;
        int n2 = 0;
        while (n2 < n) {
            String propName = stringArray[n2];
            if (!propName.equals(identifierName)) {
                try {
                    Object value = MyBeanUtils.getSimpleProperty(bean, propName);
                    if (updater.isUpdate(propName, value)) {
                        cm.setPropertyValue(po, propName, value, EntityMode.POJO);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("copy property to persistent object failed: '" + propName + "'", e);
                }
            }
            ++n2;
        }
    }

    protected Criteria createCriteria(Criterion ... criterions) {
        Criteria criteria = this.getSession().createCriteria(this.getEntityClass());
        Criterion[] criterionArray = criterions;
        int n = criterions.length;
        int n2 = 0;
        while (n2 < n) {
            Criterion c = criterionArray[n2];
            criteria.add(c);
            ++n2;
        }
        return criteria;
    }

    protected abstract Class<T> getEntityClass();
}

