/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.common.hibernate3;

import com.jeecms.common.hibernate3.Finder;
import com.jeecms.common.page.Pagination;
import com.jeecms.common.util.MyBeanUtils;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.impl.CriteriaImpl;
import org.hibernate.transform.ResultTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

public abstract class HibernateSimpleDao {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    protected static final String ORDER_ENTRIES = "orderEntries";
    protected SessionFactory sessionFactory;

    protected List find(String hql, Object ... values) {
        return this.createQuery(hql, values).list();
    }

    protected Object findUnique(String hql, Object ... values) {
        return this.createQuery(hql, values).uniqueResult();
    }

    protected Pagination find(Finder finder, int pageNo, int pageSize) {
        int totalCount = this.countQueryResult(finder);
        Pagination p = new Pagination(pageNo, pageSize, totalCount);
        if (totalCount < 1) {
            p.setList(new ArrayList());
            return p;
        }
        Query query = this.getSession().createQuery(finder.getOrigHql());
        finder.setParamsToQuery(query);
        query.setFirstResult(p.getFirstResult());
        query.setMaxResults(p.getPageSize());
        if (finder.isCacheable()) {
            query.setCacheable(true);
        }
        List list = query.list();
        p.setList(list);
        return p;
    }

    protected List find(Finder finder) {
        Query query = finder.createQuery(this.getSession());
        List list = query.list();
        return list;
    }

    protected Query createQuery(String queryString, Object ... values) {
        Assert.hasText((String)queryString);
        Query queryObject = this.getSession().createQuery(queryString);
        if (values != null) {
            int i = 0;
            while (i < values.length) {
                queryObject.setParameter(i, values[i]);
                ++i;
            }
        }
        return queryObject;
    }

    protected Pagination findByCriteria(Criteria crit, int pageNo, int pageSize) {
        List orderEntries;
        CriteriaImpl impl = (CriteriaImpl)crit;
        Projection projection = impl.getProjection();
        ResultTransformer transformer = impl.getResultTransformer();
        try {
            orderEntries = (List)MyBeanUtils.getFieldValue(impl, ORDER_ENTRIES);
            MyBeanUtils.setFieldValue(impl, ORDER_ENTRIES, new ArrayList());
        }
        catch (Exception e) {
            throw new RuntimeException("cannot read/write 'orderEntries' from CriteriaImpl", e);
        }
        int totalCount = ((Number)crit.setProjection(Projections.rowCount()).uniqueResult()).intValue();
        Pagination p = new Pagination(pageNo, pageSize, totalCount);
        if (totalCount < 1) {
            p.setList(new ArrayList());
            return p;
        }
        crit.setProjection(projection);
        if (projection == null) {
            crit.setResultTransformer(CriteriaSpecification.ROOT_ENTITY);
        }
        if (transformer != null) {
            crit.setResultTransformer(transformer);
        }
        try {
            MyBeanUtils.setFieldValue(impl, ORDER_ENTRIES, orderEntries);
        }
        catch (Exception e) {
            throw new RuntimeException("set 'orderEntries' to CriteriaImpl faild", e);
        }
        crit.setFirstResult(p.getFirstResult());
        crit.setMaxResults(p.getPageSize());
        p.setList(crit.list());
        return p;
    }

    protected int countQueryResult(Finder finder) {
        Query query = this.getSession().createQuery(finder.getRowCountHql());
        finder.setParamsToQuery(query);
        if (finder.isCacheable()) {
            query.setCacheable(true);
        }
        return ((Number)query.iterate().next()).intValue();
    }

    @Autowired
    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    protected Session getSession() {
        return this.sessionFactory.getCurrentSession();
    }
}

