/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.common.hibernate3;

import com.jeecms.common.hibernate3.HibernateTree;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.hibernate.EmptyInterceptor;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeIntercptor
extends EmptyInterceptor
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(TreeIntercptor.class);
    private ApplicationContext appCtx;
    private SessionFactory sessionFactory;
    public static final String SESSION_FACTORY = "sessionFactory";

    public void setApplicationContext(ApplicationContext appCtx) throws BeansException {
        this.appCtx = appCtx;
    }

    protected SessionFactory getSessionFactory() {
        if (this.sessionFactory == null) {
            this.sessionFactory = (SessionFactory)this.appCtx.getBean(SESSION_FACTORY, SessionFactory.class);
            if (this.sessionFactory == null) {
                throw new IllegalStateException("not found bean named 'sessionFactory',please check you spring config file.");
            }
        }
        return this.sessionFactory;
    }

    protected Session getSession() {
        return this.getSessionFactory().getCurrentSession();
    }

    public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        if (entity instanceof HibernateTree) {
            Integer myPosition;
            String hql;
            HibernateTree tree = (HibernateTree)entity;
            Object parentId = tree.getParentId();
            String beanName = tree.getClass().getName();
            Session session = this.getSession();
            FlushMode model = session.getFlushMode();
            session.setFlushMode(FlushMode.MANUAL);
            if (parentId != null) {
                hql = "select bean." + tree.getRgtName() + " from " + beanName + " bean where bean.id=:pid";
                myPosition = ((Number)session.createQuery(hql).setParameter("pid", parentId).uniqueResult()).intValue();
                String hql1 = "update " + beanName + " bean set bean." + tree.getRgtName() + " = bean." + tree.getRgtName() + " + 2 WHERE bean." + tree.getRgtName() + " >= :myPosition";
                String hql2 = "update " + beanName + " bean set bean." + tree.getLftName() + " = bean." + tree.getLftName() + " + 2 WHERE bean." + tree.getLftName() + " >= :myPosition";
                if (!StringUtils.isBlank((String)tree.getTreeCondition())) {
                    hql1 = String.valueOf(hql1) + " and (" + tree.getTreeCondition() + ")";
                    hql2 = String.valueOf(hql2) + " and (" + tree.getTreeCondition() + ")";
                }
                session.createQuery(hql1).setParameter("myPosition", (Object)myPosition).executeUpdate();
                session.createQuery(hql2).setParameter("myPosition", (Object)myPosition).executeUpdate();
            } else {
                Number myPositionNumber;
                hql = "select max(bean." + tree.getRgtName() + ") from " + beanName + " bean";
                if (!StringUtils.isBlank((String)tree.getTreeCondition())) {
                    hql = String.valueOf(hql) + " where " + tree.getTreeCondition();
                }
                myPosition = (myPositionNumber = (Number)session.createQuery(hql).uniqueResult()) == null ? Integer.valueOf(1) : Integer.valueOf(myPositionNumber.intValue() + 1);
            }
            session.setFlushMode(model);
            int i = 0;
            while (i < propertyNames.length) {
                if (propertyNames[i].equals(tree.getLftName())) {
                    state[i] = myPosition;
                }
                if (propertyNames[i].equals(tree.getRgtName())) {
                    state[i] = myPosition + 1;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
        if (!(entity instanceof HibernateTree)) {
            return false;
        }
        HibernateTree tree = (HibernateTree)entity;
        int i = 0;
        while (i < propertyNames.length) {
            if (propertyNames[i].equals(tree.getParentName())) {
                HibernateTree preParent = (HibernateTree)previousState[i];
                HibernateTree currParent = (HibernateTree)currentState[i];
                return this.updateParent(tree, preParent, currParent);
            }
            ++i;
        }
        return false;
    }

    private boolean updateParent(HibernateTree<?> tree, HibernateTree<?> preParent, HibernateTree<?> currParent) {
        Integer currParentRgt;
        int span;
        int nodeRgt;
        int nodeLft;
        Object[] position;
        String hql;
        if (preParent == null && currParent == null || preParent != null && currParent != null && preParent.getId().equals(currParent.getId())) {
            return false;
        }
        String beanName = tree.getClass().getName();
        if (log.isDebugEnabled()) {
            log.debug("update Tree {}, id={}, pre-parent id={}, curr-parent id={}", new Object[]{beanName, tree.getId(), preParent == null ? null : preParent.getId(), currParent == null ? null : currParent.getId()});
        }
        Session session = this.getSession();
        FlushMode model = session.getFlushMode();
        session.setFlushMode(FlushMode.MANUAL);
        if (currParent != null) {
            hql = "select bean." + tree.getLftName() + ",bean." + tree.getRgtName() + " from " + beanName + " bean where bean.id=:id";
            position = (Object[])session.createQuery(hql).setParameter("id", tree.getId()).uniqueResult();
            nodeLft = ((Number)position[0]).intValue();
            nodeRgt = ((Number)position[1]).intValue();
            span = nodeRgt - nodeLft + 1;
            log.debug("current node span={}", (Object)span);
            Object[] currPosition = (Object[])session.createQuery(hql).setParameter("id", currParent.getId()).uniqueResult();
            int currParentLft = ((Number)currPosition[0]).intValue();
            currParentRgt = ((Number)currPosition[1]).intValue();
            log.debug("current parent lft={} rgt={}", (Object)currParentLft, (Object)currParentRgt);
            String hql1 = "update " + beanName + " bean set bean." + tree.getRgtName() + " = bean." + tree.getRgtName() + " + " + span + " WHERE bean." + tree.getRgtName() + " >= :parentRgt";
            String hql2 = "update " + beanName + " bean set bean." + tree.getLftName() + " = bean." + tree.getLftName() + " + " + span + " WHERE bean." + tree.getLftName() + " >= :parentRgt";
            if (!StringUtils.isBlank((String)tree.getTreeCondition())) {
                hql1 = String.valueOf(hql1) + " and (" + tree.getTreeCondition() + ")";
                hql2 = String.valueOf(hql2) + " and (" + tree.getTreeCondition() + ")";
            }
            session.createQuery(hql1).setInteger("parentRgt", currParentRgt.intValue()).executeUpdate();
            session.createQuery(hql2).setInteger("parentRgt", currParentRgt.intValue()).executeUpdate();
            log.debug("vacated span hql: {}, {}, parentRgt={}", new Object[]{hql1, hql2, currParentRgt});
        } else {
            hql = "select max(bean." + tree.getRgtName() + ") from " + beanName + " bean";
            if (!StringUtils.isBlank((String)tree.getTreeCondition())) {
                hql = String.valueOf(hql) + " where " + tree.getTreeCondition();
            }
            currParentRgt = ((Number)session.createQuery(hql).uniqueResult()).intValue();
            currParentRgt = currParentRgt + 1;
            log.debug("max node left={}", (Object)currParentRgt);
        }
        hql = "select bean." + tree.getLftName() + ",bean." + tree.getRgtName() + " from " + beanName + " bean where bean.id=:id";
        position = (Object[])session.createQuery(hql).setParameter("id", tree.getId()).uniqueResult();
        nodeLft = ((Number)position[0]).intValue();
        nodeRgt = ((Number)position[1]).intValue();
        span = nodeRgt - nodeLft + 1;
        if (log.isDebugEnabled()) {
            log.debug("before adjust self left={} right={} span={}", new Object[]{nodeLft, nodeRgt, span});
        }
        int offset = currParentRgt - nodeLft;
        hql = "update " + beanName + " bean set bean." + tree.getLftName() + "=bean." + tree.getLftName() + "+:offset, bean." + tree.getRgtName() + "=bean." + tree.getRgtName() + "+:offset WHERE bean." + tree.getLftName() + " between :nodeLft and :nodeRgt";
        if (!StringUtils.isBlank((String)tree.getTreeCondition())) {
            hql = String.valueOf(hql) + " and (" + tree.getTreeCondition() + ")";
        }
        session.createQuery(hql).setParameter("offset", (Object)offset).setParameter("nodeLft", (Object)nodeLft).setParameter("nodeRgt", (Object)nodeRgt).executeUpdate();
        if (log.isDebugEnabled()) {
            log.debug("adjust self hql: {}, offset={}, nodeLft={}, nodeRgt={}", new Object[]{hql, offset, nodeLft, nodeRgt});
        }
        String hql1 = "update " + beanName + " bean set bean." + tree.getRgtName() + " = bean." + tree.getRgtName() + " - " + span + " WHERE bean." + tree.getRgtName() + " > :nodeRgt";
        String hql2 = "update " + beanName + " bean set bean." + tree.getLftName() + " = bean." + tree.getLftName() + " - " + span + " WHERE bean." + tree.getLftName() + " > :nodeRgt";
        if (!StringUtils.isBlank((String)tree.getTreeCondition())) {
            hql1 = String.valueOf(hql1) + " and (" + tree.getTreeCondition() + ")";
            hql2 = String.valueOf(hql2) + " and (" + tree.getTreeCondition() + ")";
        }
        session.createQuery(hql1).setParameter("nodeRgt", (Object)nodeRgt).executeUpdate();
        session.createQuery(hql2).setParameter("nodeRgt", (Object)nodeRgt).executeUpdate();
        if (log.isDebugEnabled()) {
            log.debug("clear span hql1:{}, hql2:{}, nodeRgt:{}", new Object[]{hql1, hql2, nodeRgt});
        }
        session.setFlushMode(model);
        return true;
    }

    public void onDelete(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        if (entity instanceof HibernateTree) {
            HibernateTree tree = (HibernateTree)entity;
            String beanName = tree.getClass().getName();
            Session session = this.getSession();
            FlushMode model = session.getFlushMode();
            session.setFlushMode(FlushMode.MANUAL);
            String hql = "select bean." + tree.getLftName() + " from " + beanName + " bean where bean.id=:id";
            Integer myPosition = ((Number)session.createQuery(hql).setParameter("id", tree.getId()).uniqueResult()).intValue();
            String hql1 = "update " + beanName + " bean set bean." + tree.getRgtName() + " = bean." + tree.getRgtName() + " - 2 WHERE bean." + tree.getRgtName() + " > :myPosition";
            String hql2 = "update " + beanName + " bean set bean." + tree.getLftName() + " = bean." + tree.getLftName() + " - 2 WHERE bean." + tree.getLftName() + " > :myPosition";
            if (!StringUtils.isBlank((String)tree.getTreeCondition())) {
                hql1 = String.valueOf(hql1) + " and (" + tree.getTreeCondition() + ")";
                hql2 = String.valueOf(hql2) + " and (" + tree.getTreeCondition() + ")";
            }
            session.createQuery(hql1).setInteger("myPosition", myPosition.intValue()).executeUpdate();
            session.createQuery(hql2).setInteger("myPosition", myPosition.intValue()).executeUpdate();
            session.setFlushMode(model);
        }
    }
}

