/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.common.image;

import com.jeecms.common.image.ImageUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;

public class AverageImageScale {
    public static void resizeFix(File srcFile, File destFile, int boxWidth, int boxHeight) throws IOException {
        int zoomHeight;
        int zoomWidth;
        BufferedImage srcImgBuff = ImageIO.read(srcFile);
        int width = srcImgBuff.getWidth();
        int height = srcImgBuff.getHeight();
        if (width <= boxWidth && height <= boxHeight) {
            FileUtils.copyFile((File)srcFile, (File)destFile);
            return;
        }
        if ((float)width / (float)height > (float)boxWidth / (float)boxHeight) {
            zoomWidth = boxWidth;
            zoomHeight = Math.round((float)boxWidth * (float)height / (float)width);
        } else {
            zoomWidth = Math.round((float)boxHeight * (float)width / (float)height);
            zoomHeight = boxHeight;
        }
        BufferedImage imgBuff = AverageImageScale.scaleImage(srcImgBuff, width, height, zoomWidth, zoomHeight);
        AverageImageScale.writeFile(imgBuff, destFile);
    }

    public static void resizeFix(File srcFile, File destFile, int boxWidth, int boxHeight, int cutTop, int cutLeft, int cutWidth, int catHeight) throws IOException {
        int zoomHeight;
        int zoomWidth;
        BufferedImage srcImgBuff = ImageIO.read(srcFile);
        srcImgBuff = srcImgBuff.getSubimage(cutTop, cutLeft, cutWidth, catHeight);
        int width = srcImgBuff.getWidth();
        int height = srcImgBuff.getHeight();
        if (width <= boxWidth && height <= boxHeight) {
            AverageImageScale.writeFile(srcImgBuff, destFile);
            return;
        }
        if ((float)width / (float)height > (float)boxWidth / (float)boxHeight) {
            zoomWidth = boxWidth;
            zoomHeight = Math.round((float)boxWidth * (float)height / (float)width);
        } else {
            zoomWidth = Math.round((float)boxHeight * (float)width / (float)height);
            zoomHeight = boxHeight;
        }
        BufferedImage imgBuff = AverageImageScale.scaleImage(srcImgBuff, width, height, zoomWidth, zoomHeight);
        AverageImageScale.writeFile(imgBuff, destFile);
    }

    public static void writeFile(BufferedImage imgBuf, File destFile) throws IOException {
        File parent = destFile.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        ImageIO.write((RenderedImage)imgBuf, "jpeg", destFile);
    }

    public static void imageMark(File srcFile, File destFile, int minWidth, int minHeight, int pos, int offsetX, int offsetY, String text, Color color, int size, int alpha) throws IOException {
        BufferedImage imgBuff = ImageIO.read(srcFile);
        int width = imgBuff.getWidth();
        int height = imgBuff.getHeight();
        if (width <= minWidth || height <= minHeight) {
            imgBuff = null;
            if (!srcFile.equals(destFile)) {
                FileUtils.copyFile((File)srcFile, (File)destFile);
            }
        } else {
            AverageImageScale.imageMark(imgBuff, width, height, pos, offsetX, offsetY, text, color, size, alpha);
            AverageImageScale.writeFile(imgBuff, destFile);
            imgBuff = null;
        }
    }

    public static void imageMark(File srcFile, File destFile, int minWidth, int minHeight, int pos, int offsetX, int offsetY, File markFile) throws IOException {
        BufferedImage imgBuff = ImageIO.read(srcFile);
        int width = imgBuff.getWidth();
        int height = imgBuff.getHeight();
        if (width <= minWidth || height <= minHeight) {
            imgBuff = null;
            if (!srcFile.equals(destFile)) {
                FileUtils.copyFile((File)srcFile, (File)destFile);
            }
        } else {
            AverageImageScale.imageMark(imgBuff, width, height, pos, offsetX, offsetY, markFile);
            AverageImageScale.writeFile(imgBuff, destFile);
            imgBuff = null;
        }
    }

    private static void imageMark(BufferedImage imgBuff, int width, int height, int pos, int offsetX, int offsetY, String text, Color color, int size, int alpha) throws IOException {
        ImageUtils.Position p = ImageUtils.markPosition(width, height, pos, offsetX, offsetY);
        Graphics2D g = imgBuff.createGraphics();
        g.setColor(color);
        g.setFont(new Font(null, 0, size));
        AlphaComposite a = AlphaComposite.getInstance(10, (float)alpha / 100.0f);
        g.setComposite(a);
        g.drawString(text, p.getX(), p.getY());
        g.dispose();
    }

    private static void imageMark(BufferedImage imgBuff, int width, int height, int pos, int offsetX, int offsetY, File markFile) throws IOException {
        ImageUtils.Position p = ImageUtils.markPosition(width, height, pos, offsetX, offsetY);
        Graphics2D g = imgBuff.createGraphics();
        AlphaComposite a = AlphaComposite.getInstance(10);
        g.setComposite(a);
        g.drawImage((Image)ImageIO.read(markFile), p.getX(), p.getY(), null);
        g.dispose();
    }

    private static BufferedImage scaleImage(BufferedImage srcImgBuff, int width, int height, int zoomWidth, int zoomHeight) {
        int[] colorArray = srcImgBuff.getRGB(0, 0, width, height, null, 0, width);
        BufferedImage outBuff = new BufferedImage(zoomWidth, zoomHeight, 1);
        float wScale = (float)width / (float)zoomWidth;
        int wScaleInt = (int)((double)wScale + 0.5);
        float hScale = (float)height / (float)zoomHeight;
        int hScaleInt = (int)((double)hScale + 0.5);
        int area = wScaleInt * hScaleInt;
        int y = 0;
        while (y < zoomHeight) {
            int y0 = (int)((float)y * hScale);
            int y1 = y0 + hScaleInt;
            int x = 0;
            while (x < zoomWidth) {
                int x0 = (int)((float)x * wScale);
                int x1 = x0 + wScaleInt;
                long blue = 0L;
                long green = 0L;
                long red = 0L;
                int i = x0;
                while (i < x1) {
                    int j = y0;
                    while (j < y1) {
                        int color = colorArray[width * j + i];
                        red += (long)AverageImageScale.getRedValue(color);
                        green += (long)AverageImageScale.getGreenValue(color);
                        blue += (long)AverageImageScale.getBlueValue(color);
                        ++j;
                    }
                    ++i;
                }
                outBuff.setRGB(x, y, AverageImageScale.comRGB((int)(red / (long)area), (int)(green / (long)area), (int)(blue / (long)area)));
                ++x;
            }
            ++y;
        }
        return outBuff;
    }

    private static int getRedValue(int rgbValue) {
        return (rgbValue & 0xFF0000) >> 16;
    }

    private static int getGreenValue(int rgbValue) {
        return (rgbValue & 0xFF00) >> 8;
    }

    private static int getBlueValue(int rgbValue) {
        return rgbValue & 0xFF;
    }

    private static int comRGB(int redValue, int greenValue, int blueValue) {
        return (redValue << 16) + (greenValue << 8) + blueValue;
    }

    public static void main(String[] args) throws Exception {
        long time = System.currentTimeMillis();
        AverageImageScale.resizeFix(new File("test/com/jeecms/common/util/1.bmp"), new File("test/com/jeecms/common/util/1-n-2.bmp"), 310, 310, 50, 50, 320, 320);
        time = System.currentTimeMillis() - time;
        System.out.println("resize2 img in " + time + "ms");
    }
}

