/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.common.image;

import com.jeecms.common.image.AverageImageScale;
import com.jeecms.common.image.ImageScale;
import com.jeecms.common.image.MagickImageScale;
import java.awt.Color;
import java.io.File;
import magick.Magick;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageScaleImpl
implements ImageScale {
    private static final Logger log = LoggerFactory.getLogger(ImageScaleImpl.class);
    private boolean isMagick = false;
    private boolean tryMagick = true;

    public void resizeFix(File srcFile, File destFile, int boxWidth, int boxHeight) throws Exception {
        if (this.isMagick) {
            MagickImageScale.resizeFix(srcFile, destFile, boxWidth, boxHeight);
        } else {
            AverageImageScale.resizeFix(srcFile, destFile, boxWidth, boxHeight);
        }
    }

    public void resizeFix(File srcFile, File destFile, int boxWidth, int boxHeight, int cutTop, int cutLeft, int cutWidth, int catHeight) throws Exception {
        if (this.isMagick) {
            MagickImageScale.resizeFix(srcFile, destFile, boxWidth, boxHeight, cutTop, cutLeft, cutWidth, catHeight);
        } else {
            AverageImageScale.resizeFix(srcFile, destFile, boxWidth, boxHeight, cutTop, cutLeft, cutWidth, catHeight);
        }
    }

    public void imageMark(File srcFile, File destFile, int minWidth, int minHeight, int pos, int offsetX, int offsetY, String text, Color color, int size, int alpha) throws Exception {
        if (this.isMagick) {
            MagickImageScale.imageMark(srcFile, destFile, minWidth, minHeight, pos, offsetX, offsetY, text, color, size, alpha);
        } else {
            AverageImageScale.imageMark(srcFile, destFile, minWidth, minHeight, pos, offsetX, offsetY, text, color, size, alpha);
        }
    }

    public void imageMark(File srcFile, File destFile, int minWidth, int minHeight, int pos, int offsetX, int offsetY, File markFile) throws Exception {
        if (this.isMagick) {
            MagickImageScale.imageMark(srcFile, destFile, minWidth, minHeight, pos, offsetX, offsetY, markFile);
        } else {
            AverageImageScale.imageMark(srcFile, destFile, minWidth, minHeight, pos, offsetX, offsetY, markFile);
        }
    }

    public void init() {
        if (this.tryMagick) {
            try {
                System.setProperty("jmagick.systemclassloader", "no");
                new Magick();
                log.info("using jmagick");
                this.isMagick = true;
            }
            catch (Throwable e) {
                log.warn("load jmagick fail, use java image scale. message:{}", (Object)e.getMessage());
                this.isMagick = false;
            }
        } else {
            log.info("jmagick is disabled.");
            this.isMagick = false;
        }
    }

    public void setTryMagick(boolean tryMagick) {
        this.tryMagick = tryMagick;
    }
}

