/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.common.image;

import com.jeecms.common.image.ImageInfo;
import java.io.InputStream;
import java.util.Locale;

public abstract class ImageUtils {
    public static final String[] IMAGE_EXT = new String[]{"jpg", "jpeg", "gif", "png", "bmp"};

    public static boolean isValidImageExt(String ext) {
        ext = ext.toLowerCase(Locale.ENGLISH);
        String[] stringArray = IMAGE_EXT;
        int n = IMAGE_EXT.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.equalsIgnoreCase(ext)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isImage(InputStream in) {
        ImageInfo ii = new ImageInfo();
        ii.setInput(in);
        return ii.check();
    }

    public static Position markPosition(int width, int height, int p, int offsetx, int offsety) {
        int y;
        int x;
        if (p < 1 || p > 5) {
            p = (int)(Math.random() * 5.0) + 1;
        }
        switch (p) {
            case 1: {
                x = offsetx;
                y = offsety;
                break;
            }
            case 2: {
                x = width + offsetx;
                y = offsety;
                break;
            }
            case 3: {
                x = offsetx;
                y = height + offsety;
                break;
            }
            case 4: {
                x = width + offsetx;
                y = height + offsety;
                break;
            }
            case 5: {
                x = width / 2 + offsetx;
                y = height / 2 + offsety;
                break;
            }
            default: {
                throw new RuntimeException("never reach ...");
            }
        }
        return new Position(x, y);
    }

    public static class Position {
        private int x;
        private int y;

        public Position(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public int getX() {
            return this.x;
        }

        public void setX(int x) {
            this.x = x;
        }

        public int getY() {
            return this.y;
        }

        public void setY(int y) {
            this.y = y;
        }
    }
}

