/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.common.ipseek;

import com.jeecms.common.ipseek.IPLocation;
import com.jeecms.common.ipseek.IPParseException;
import com.jeecms.common.ipseek.IPSeeker;
import com.jeecms.common.ipseek.Util;
import com.jeecms.common.web.springmvc.RealPathResolver;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class IPSeekerImpl
implements IPSeeker {
    private Map<String, IPLocation> ipCache;
    private RandomAccessFile ipFile;
    private long ipBegin;
    private long ipEnd;
    private IPLocation loc;
    private byte[] b4;
    private byte[] b3;
    private String dir;
    private String filename;
    @Autowired
    private RealPathResolver realPathResolver;

    public void init() {
        String file = String.valueOf(this.realPathResolver.get(this.dir)) + File.separator + this.filename;
        this.ipCache = new HashMap<String, IPLocation>();
        this.loc = new IPLocation();
        this.b4 = new byte[4];
        this.b3 = new byte[3];
        try {
            this.ipFile = new RandomAccessFile(file, "r");
        }
        catch (FileNotFoundException e) {
            throw new IPParseException("ip data file not found!", e);
        }
        if (this.ipFile != null) {
            try {
                this.ipBegin = this.readLong4(0L);
                this.ipEnd = this.readLong4(4L);
                if (this.ipBegin == -1L || this.ipEnd == -1L) {
                    this.ipFile.close();
                    this.ipFile = null;
                }
            }
            catch (IOException e) {
                this.ipFile = null;
            }
        }
    }

    public IPLocation getIPLocation(String ip) {
        return new IPLocation(this.getCountry(ip), this.getArea(ip));
    }

    public String getCountry(byte[] ip) {
        if (this.ipFile == null) {
            return "IP\u5730\u5740\u5e93\u6587\u4ef6\u9519\u8bef";
        }
        String ipStr = Util.getIpStringFromBytes(ip);
        if (this.ipCache.containsKey(ipStr)) {
            IPLocation ipLoc = this.ipCache.get(ipStr);
            return ipLoc.getCountry();
        }
        IPLocation ipLoc = this.getIPLocation(ip);
        this.ipCache.put(ipStr, ipLoc.getCopy());
        return ipLoc.getCountry();
    }

    public String getCountry(String ip) {
        return this.getCountry(Util.getIpByteArrayFromString(ip));
    }

    public String getArea(byte[] ip) {
        if (this.ipFile == null) {
            return "IP\u5730\u5740\u5e93\u6587\u4ef6\u9519\u8bef";
        }
        String ipStr = Util.getIpStringFromBytes(ip);
        if (this.ipCache.containsKey(ipStr)) {
            IPLocation ipLoc = this.ipCache.get(ipStr);
            return ipLoc.getArea();
        }
        IPLocation ipLoc = this.getIPLocation(ip);
        this.ipCache.put(ipStr, ipLoc.getCopy());
        return ipLoc.getArea();
    }

    public String getArea(String ip) {
        return this.getArea(Util.getIpByteArrayFromString(ip));
    }

    private IPLocation getIPLocation(byte[] ip) {
        IPLocation info = null;
        long offset = this.locateIP(ip);
        if (offset != -1L) {
            info = this.getIPLocation(offset);
        }
        if (info == null) {
            info = new IPLocation();
            info.setCountry("\u672a\u77e5\u56fd\u5bb6");
            info.setArea("\u672a\u77e5\u5730\u533a");
        }
        return info;
    }

    private long readLong4(long offset) {
        long ret = 0L;
        try {
            this.ipFile.seek(offset);
            ret |= (long)(this.ipFile.readByte() & 0xFF);
            ret |= (long)(this.ipFile.readByte() << 8 & 0xFF00);
            ret |= (long)(this.ipFile.readByte() << 16 & 0xFF0000);
            return ret |= (long)(this.ipFile.readByte() << 24 & 0xFF000000);
        }
        catch (IOException e) {
            return -1L;
        }
    }

    private long readLong3(long offset) {
        long ret = 0L;
        try {
            this.ipFile.seek(offset);
            this.ipFile.readFully(this.b3);
            ret |= (long)(this.b3[0] & 0xFF);
            ret |= (long)(this.b3[1] << 8 & 0xFF00);
            return ret |= (long)(this.b3[2] << 16 & 0xFF0000);
        }
        catch (IOException e) {
            return -1L;
        }
    }

    private long readLong3() {
        long ret = 0L;
        try {
            this.ipFile.readFully(this.b3);
            ret |= (long)(this.b3[0] & 0xFF);
            ret |= (long)(this.b3[1] << 8 & 0xFF00);
            return ret |= (long)(this.b3[2] << 16 & 0xFF0000);
        }
        catch (IOException e) {
            return -1L;
        }
    }

    private void readIP(long offset, byte[] ip) {
        try {
            this.ipFile.seek(offset);
            this.ipFile.readFully(ip);
            byte temp = ip[0];
            ip[0] = ip[3];
            ip[3] = temp;
            temp = ip[1];
            ip[1] = ip[2];
            ip[2] = temp;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private int compareIP(byte[] ip, byte[] beginIp) {
        int i = 0;
        while (i < 4) {
            int r = this.compareByte(ip[i], beginIp[i]);
            if (r != 0) {
                return r;
            }
            ++i;
        }
        return 0;
    }

    private int compareByte(byte b1, byte b2) {
        if ((b1 & 0xFF) > (b2 & 0xFF)) {
            return 1;
        }
        if ((b1 ^ b2) == 0) {
            return 0;
        }
        return -1;
    }

    private long locateIP(byte[] ip) {
        long m = 0L;
        this.readIP(this.ipBegin, this.b4);
        int r = this.compareIP(ip, this.b4);
        if (r == 0) {
            return this.ipBegin;
        }
        if (r < 0) {
            return -1L;
        }
        long i = this.ipBegin;
        long j = this.ipEnd;
        while (i < j) {
            m = this.getMiddleOffset(i, j);
            this.readIP(m, this.b4);
            r = this.compareIP(ip, this.b4);
            if (r > 0) {
                i = m;
                continue;
            }
            if (r < 0) {
                if (m == j) {
                    m = j -= 7L;
                    continue;
                }
                j = m;
                continue;
            }
            return this.readLong3(m + 4L);
        }
        m = this.readLong3(m + 4L);
        this.readIP(m, this.b4);
        r = this.compareIP(ip, this.b4);
        if (r <= 0) {
            return m;
        }
        return -1L;
    }

    private long getMiddleOffset(long begin, long end) {
        long records = (end - begin) / 7L;
        if ((records >>= 1) == 0L) {
            records = 1L;
        }
        return begin + records * 7L;
    }

    private IPLocation getIPLocation(long offset) {
        try {
            this.ipFile.seek(offset + 4L);
            byte b = this.ipFile.readByte();
            if (b == 1) {
                long countryOffset = this.readLong3();
                this.ipFile.seek(countryOffset);
                b = this.ipFile.readByte();
                if (b == 2) {
                    this.loc.setCountry(this.readString(this.readLong3()));
                    this.ipFile.seek(countryOffset + 4L);
                } else {
                    this.loc.setCountry(this.readString(countryOffset));
                }
                this.loc.setArea(this.readArea(this.ipFile.getFilePointer()));
            } else if (b == 2) {
                this.loc.setCountry(this.readString(this.readLong3()));
                this.loc.setArea(this.readArea(offset + 8L));
            } else {
                this.loc.setCountry(this.readString(this.ipFile.getFilePointer() - 1L));
                this.loc.setArea(this.readArea(this.ipFile.getFilePointer()));
            }
            return this.loc;
        }
        catch (IOException e) {
            return null;
        }
    }

    private String readArea(long offset) throws IOException {
        this.ipFile.seek(offset);
        byte b = this.ipFile.readByte();
        if (b == 1 || b == 2) {
            long areaOffset = this.readLong3(offset + 1L);
            if (areaOffset == 0L) {
                return "\u672a\u77e5\u5730\u533a";
            }
            return this.readString(areaOffset);
        }
        return this.readString(offset);
    }

    private String readString(long offset) {
        try {
            this.ipFile.seek(offset);
            int i = 0;
            byte[] buf = new byte[100];
            while ((buf[i] = this.ipFile.readByte()) != 0) {
                if (++i < buf.length) continue;
                byte[] tmp = new byte[i + 100];
                System.arraycopy(buf, 0, tmp, 0, i);
                buf = tmp;
            }
            if (i != 0) {
                return Util.getString(buf, 0, i, "GBK");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "";
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }
}

