/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.common.page;

import com.jeecms.common.page.Paginable;

public class SimplePage
implements Paginable {
    private static final long serialVersionUID = 1L;
    public static final int DEF_COUNT = 20;
    protected int totalCount = 0;
    protected int pageSize = 20;
    protected int pageNo = 1;

    public static int cpn(Integer pageNo) {
        return pageNo == null || pageNo < 1 ? 1 : pageNo;
    }

    public SimplePage() {
    }

    public SimplePage(int pageNo, int pageSize, int totalCount) {
        this.setTotalCount(totalCount);
        this.setPageSize(pageSize);
        this.setPageNo(pageNo);
        this.adjustPageNo();
    }

    public void adjustPageNo() {
        if (this.pageNo == 1) {
            return;
        }
        int tp = this.getTotalPage();
        if (this.pageNo > tp) {
            this.pageNo = tp;
        }
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public int getTotalPage() {
        int totalPage = this.totalCount / this.pageSize;
        if (totalPage == 0 || this.totalCount % this.pageSize != 0) {
            ++totalPage;
        }
        return totalPage;
    }

    public boolean isFirstPage() {
        return this.pageNo <= 1;
    }

    public boolean isLastPage() {
        return this.pageNo >= this.getTotalPage();
    }

    public int getNextPage() {
        if (this.isLastPage()) {
            return this.pageNo;
        }
        return this.pageNo + 1;
    }

    public int getPrePage() {
        if (this.isFirstPage()) {
            return this.pageNo;
        }
        return this.pageNo - 1;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount < 0 ? 0 : totalCount;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize < 1 ? 20 : pageSize;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo < 1 ? 1 : pageNo;
    }
}

