/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.common.security.userdetails;

import com.jeecms.common.security.AccountExpiredException;
import com.jeecms.common.security.AccountStatusException;
import com.jeecms.common.security.CredentialsExpiredException;
import com.jeecms.common.security.DisabledException;
import com.jeecms.common.security.LockedException;
import com.jeecms.common.security.userdetails.UserDetails;
import com.jeecms.common.security.userdetails.UserDetailsChecker;

public class AccountStatusUserDetailsChecker
implements UserDetailsChecker {
    public void check(UserDetails user) throws AccountStatusException {
        if (!user.isAccountNonLocked()) {
            throw new LockedException();
        }
        if (!user.isEnabled()) {
            throw new DisabledException("User is disabled", user);
        }
        if (!user.isAccountNonExpired()) {
            throw new AccountExpiredException("User account has expired", user);
        }
        if (!user.isCredentialsNonExpired()) {
            throw new CredentialsExpiredException("User credentials have expired", user);
        }
    }
}

