/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.common.util;

public class Num62 {
    public static final char[] N62_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    public static final char[] N36_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    public static final int LONG_N36_LEN = 13;
    public static final int LONG_N62_LEN = 11;

    private static StringBuilder longToNBuf(long l, char[] chars) {
        int upgrade = chars.length;
        StringBuilder result = new StringBuilder();
        while (l > 0L) {
            int last = (int)(l % (long)upgrade);
            result.append(chars[last]);
            l /= (long)upgrade;
        }
        return result;
    }

    public static String longToN62(long l) {
        return Num62.longToNBuf(l, N62_CHARS).reverse().toString();
    }

    public static String longToN36(long l) {
        return Num62.longToNBuf(l, N36_CHARS).reverse().toString();
    }

    public static String longToN62(long l, int length) {
        StringBuilder sb = Num62.longToNBuf(l, N62_CHARS);
        int i = sb.length();
        while (i < length) {
            sb.append('0');
            ++i;
        }
        return sb.reverse().toString();
    }

    public static String longToN36(long l, int length) {
        StringBuilder sb = Num62.longToNBuf(l, N36_CHARS);
        int i = sb.length();
        while (i < length) {
            sb.append('0');
            ++i;
        }
        return sb.reverse().toString();
    }

    public static long n62ToLong(String n62) {
        return Num62.nToLong(n62, N62_CHARS);
    }

    public static long n36ToLong(String n36) {
        return Num62.nToLong(n36, N36_CHARS);
    }

    private static long nToLong(String s, char[] chars) {
        char[] nc = s.toCharArray();
        long result = 0L;
        long pow = 1L;
        int i = nc.length - 1;
        while (i >= 0) {
            int n = Num62.findNIndex(nc[i], chars);
            result += (long)n * pow;
            --i;
            pow *= (long)chars.length;
        }
        return result;
    }

    private static int findNIndex(char c, char[] chars) {
        int i = 0;
        while (i < chars.length) {
            if (c == chars[i]) {
                return i;
            }
            ++i;
        }
        throw new RuntimeException("N62(N36)\u975e\u6cd5\u5b57\u7b26\uff1a" + c);
    }

    public static void main(String[] args) {
        System.out.println(Num62.longToN62(Long.MAX_VALUE));
    }
}

