/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.common.util;

import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.htmlparser.Node;
import org.htmlparser.lexer.Lexer;
import org.htmlparser.nodes.TextNode;
import org.htmlparser.util.ParserException;

public class StrUtils {
    private StrUtils() {
    }

    public static String handelUrl(String url) {
        if (url == null) {
            return null;
        }
        if ((url = url.trim()).equals("") || url.startsWith("http://") || url.startsWith("https://")) {
            return url;
        }
        return "http://" + url.trim();
    }

    public static String[] splitAndTrim(String str, String sep, String sep2) {
        if (StringUtils.isBlank((String)str)) {
            return null;
        }
        if (!StringUtils.isBlank((String)sep2)) {
            str = StringUtils.replace((String)str, (String)sep2, (String)sep);
        }
        String[] arr = StringUtils.split((String)str, (String)sep);
        int i = 0;
        int len = arr.length;
        while (i < len) {
            arr[i] = arr[i].trim();
            ++i;
        }
        return arr;
    }

    public static String txt2htm(String txt) {
        if (StringUtils.isBlank((String)txt)) {
            return txt;
        }
        StringBuilder sb = new StringBuilder((int)((double)txt.length() * 1.2));
        boolean doub = false;
        int i = 0;
        while (i < txt.length()) {
            char c = txt.charAt(i);
            if (c == ' ') {
                if (doub) {
                    sb.append(' ');
                    doub = false;
                } else {
                    sb.append("&nbsp;");
                    doub = true;
                }
            } else {
                doub = false;
                switch (c) {
                    case '&': {
                        sb.append("&amp;");
                        break;
                    }
                    case '<': {
                        sb.append("&lt;");
                        break;
                    }
                    case '>': {
                        sb.append("&gt;");
                        break;
                    }
                    case '\"': {
                        sb.append("&quot;");
                        break;
                    }
                    case '\n': {
                        sb.append("<br/>");
                        break;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static String textCut(String s, int len, String append) {
        if (s == null) {
            return null;
        }
        int slen = s.length();
        if (slen <= len) {
            return s;
        }
        int maxCount = len * 2;
        int count = 0;
        int i = 0;
        while (count < maxCount && i < slen) {
            count = s.codePointAt(i) < 256 ? ++count : (count += 2);
            ++i;
        }
        if (i < slen) {
            if (count > maxCount) {
                --i;
            }
            if (!StringUtils.isBlank((String)append)) {
                i = s.codePointAt(i - 1) < 256 ? (i -= 2) : --i;
                return String.valueOf(s.substring(0, i)) + append;
            }
            return s.substring(0, i);
        }
        return s;
    }

    public static String htmlCut(String s, int len, String append) {
        String text = StrUtils.html2Text(s, len * 2);
        return StrUtils.textCut(text, len, append);
    }

    public static String html2Text(String html, int len) {
        try {
            Node node;
            Lexer lexer = new Lexer(html);
            StringBuilder sb = new StringBuilder(html.length());
            while ((node = lexer.nextNode()) != null) {
                if (node instanceof TextNode) {
                    sb.append(node.toHtml());
                }
                if (sb.length() > len) break;
            }
            return sb.toString();
        }
        catch (ParserException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean contains(String str, String search) {
        if (StringUtils.isBlank((String)str) || StringUtils.isBlank((String)search)) {
            return false;
        }
        String reg = StringUtils.replace((String)search, (String)"*", (String)".*");
        Pattern p = Pattern.compile(reg);
        return p.matcher(str).matches();
    }
}

