/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.common.web;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.springframework.util.Assert;

public class CookieUtils {
    public static final String COOKIE_PAGE_SIZE = "_cookie_page_size";
    public static final int DEFAULT_SIZE = 20;
    public static final int MAX_SIZE = 200;

    public static int getPageSize(HttpServletRequest request) {
        Assert.notNull((Object)request);
        Cookie cookie = CookieUtils.getCookie(request, COOKIE_PAGE_SIZE);
        int count = 0;
        if (cookie != null && NumberUtils.isDigits((String)cookie.getValue())) {
            count = Integer.parseInt(cookie.getValue());
        }
        if (count <= 0) {
            count = 20;
        } else if (count > 200) {
            count = 200;
        }
        return count;
    }

    public static Cookie getCookie(HttpServletRequest request, String name) {
        Assert.notNull((Object)request);
        Cookie[] cookies = request.getCookies();
        if (cookies != null && cookies.length > 0) {
            Cookie[] cookieArray = cookies;
            int n = cookies.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie c = cookieArray[n2];
                if (c.getName().equals(name)) {
                    return c;
                }
                ++n2;
            }
        }
        return null;
    }

    public static Cookie addCookie(HttpServletRequest request, HttpServletResponse response, String name, String value, Integer expiry, String domain) {
        String ctx;
        Cookie cookie = new Cookie(name, value);
        if (expiry != null) {
            cookie.setMaxAge(expiry.intValue());
        }
        if (StringUtils.isNotBlank((String)domain)) {
            cookie.setDomain(domain);
        }
        cookie.setPath(StringUtils.isBlank((String)(ctx = request.getContextPath())) ? "/" : ctx);
        response.addCookie(cookie);
        return cookie;
    }

    public static void cancleCookie(HttpServletRequest request, HttpServletResponse response, String name, String domain) {
        Cookie cookie = new Cookie(name, "");
        cookie.setMaxAge(0);
        String ctx = request.getContextPath();
        cookie.setPath(StringUtils.isBlank((String)ctx) ? "/" : ctx);
        if (StringUtils.isNotBlank((String)domain)) {
            cookie.setDomain(domain);
        }
        response.addCookie(cookie);
    }
}

