/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.common.web.cos;

import com.jeecms.common.web.cos.CosMultipartRequest;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.support.AbstractMultipartHttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CosMultipartHttpServletRequest
extends AbstractMultipartHttpServletRequest {
    protected static final Logger logger = LoggerFactory.getLogger(CosMultipartHttpServletRequest.class);
    private final CosMultipartRequest multipartRequest;

    protected CosMultipartHttpServletRequest(HttpServletRequest request, CosMultipartRequest multipartRequest) {
        super(request);
        this.multipartRequest = multipartRequest;
        this.setMultipartFiles(this.initFileMap(multipartRequest));
    }

    public CosMultipartRequest getMultipartRequest() {
        return this.multipartRequest;
    }

    private MultiValueMap<String, MultipartFile> initFileMap(CosMultipartRequest multipartRequest) {
        LinkedMultiValueMap files = new LinkedMultiValueMap();
        Set<String> fileNames = multipartRequest.getFileNames();
        for (String fileName : fileNames) {
            files.add((Object)fileName, (Object)new CosMultipartFile(fileName));
        }
        return files;
    }

    public Enumeration<String> getParameterNames() {
        return this.multipartRequest.getParameterNames();
    }

    public String getParameter(String name) {
        return this.multipartRequest.getParameter(name);
    }

    public String[] getParameterValues(String name) {
        return this.multipartRequest.getParameterValues(name);
    }

    public Map<String, String[]> getParameterMap() {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        Enumeration<String> names = this.getParameterNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement();
            params.put(name, this.getParameterValues(name));
        }
        return Collections.unmodifiableMap(params);
    }

    private class CosMultipartFile
    implements MultipartFile {
        private final String name;
        private final File file;
        private final long size;

        public CosMultipartFile(String name) {
            this.name = name;
            this.file = CosMultipartHttpServletRequest.this.multipartRequest.getFile(this.name);
            this.size = this.file != null ? this.file.length() : 0L;
        }

        public String getName() {
            return this.name;
        }

        public String getOriginalFilename() {
            String filename = CosMultipartHttpServletRequest.this.multipartRequest.getOriginalFileName(this.name);
            return filename != null ? filename : "";
        }

        public String getContentType() {
            return CosMultipartHttpServletRequest.this.multipartRequest.getContentType(this.name);
        }

        public boolean isEmpty() {
            return this.size == 0L;
        }

        public long getSize() {
            return this.size;
        }

        public byte[] getBytes() throws IOException {
            if (this.file != null && !this.file.exists()) {
                throw new IllegalStateException("File has been moved - cannot be read again");
            }
            return this.size > 0L ? FileCopyUtils.copyToByteArray((File)this.file) : new byte[]{};
        }

        public InputStream getInputStream() throws IOException {
            if (this.file != null && !this.file.exists()) {
                throw new IllegalStateException("File has been moved - cannot be read again");
            }
            if (this.size != 0L) {
                return new FileInputStream(this.file);
            }
            return new ByteArrayInputStream(new byte[0]);
        }

        public void transferTo(File dest) throws IOException, IllegalStateException {
            if (this.file != null && !this.file.exists()) {
                throw new IllegalStateException("File has already been moved - cannot be transferred again");
            }
            if (dest.exists() && !dest.delete()) {
                throw new IOException("Destination file [" + dest.getAbsolutePath() + "] already exists and could not be deleted");
            }
            boolean moved = false;
            if (this.file != null) {
                moved = this.file.renameTo(dest);
                if (!moved) {
                    FileCopyUtils.copy((File)this.file, (File)dest);
                }
            } else {
                dest.createNewFile();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Multipart file '" + this.getName() + "' with original filename [" + this.getOriginalFilename() + "], stored " + (this.file != null ? "at [" + this.file.getAbsolutePath() + "]" : "in memory") + ": " + (moved ? "moved" : "copied") + " to [" + dest.getAbsolutePath() + "]");
            }
        }
    }
}

