/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.common.web.cos;

import com.jeecms.common.web.RequestUtils;
import com.jeecms.common.web.cos.FilePart;
import com.jeecms.common.web.cos.FileRenamePolicy;
import com.jeecms.common.web.cos.MultipartParser;
import com.jeecms.common.web.cos.ParamPart;
import com.jeecms.common.web.cos.Part;
import com.jeecms.common.web.cos.UploadedFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CosMultipartRequest {
    private static final int DEFAULT_MAX_POST_SIZE = 0x100000;
    protected Hashtable<String, List<String>> parameters = new Hashtable();
    protected Map<String, UploadedFile> files = new HashMap<String, UploadedFile>();

    public CosMultipartRequest(HttpServletRequest request, String saveDirectory) throws IOException {
        this(request, saveDirectory, 0x100000);
    }

    public CosMultipartRequest(HttpServletRequest request, String saveDirectory, int maxPostSize) throws IOException {
        this(request, saveDirectory, maxPostSize, null, null);
    }

    public CosMultipartRequest(HttpServletRequest request, String saveDirectory, String encoding) throws IOException {
        this(request, saveDirectory, 0x100000, encoding, null);
    }

    public CosMultipartRequest(HttpServletRequest request, String saveDirectory, int maxPostSize, FileRenamePolicy policy) throws IOException {
        this(request, saveDirectory, maxPostSize, null, policy);
    }

    public CosMultipartRequest(HttpServletRequest request, String saveDirectory, int maxPostSize, String encoding) throws IOException {
        this(request, saveDirectory, maxPostSize, encoding, null);
    }

    public CosMultipartRequest(HttpServletRequest request, String saveDirectory, int maxPostSize, String encoding, FileRenamePolicy policy) throws IOException {
        Part part;
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        if (saveDirectory == null) {
            throw new IllegalArgumentException("saveDirectory cannot be null");
        }
        if (maxPostSize <= 0) {
            throw new IllegalArgumentException("maxPostSize must be positive");
        }
        File dir = new File(saveDirectory);
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + saveDirectory);
        }
        if (!dir.canWrite()) {
            throw new IllegalArgumentException("Not writable: " + saveDirectory);
        }
        MultipartParser parser = new MultipartParser(request, maxPostSize, true, true, encoding);
        if (request.getQueryString() != null) {
            Map<String, String[]> queryParameters = RequestUtils.parseQueryString(request.getQueryString());
            for (Map.Entry<String, String[]> entry : queryParameters.entrySet()) {
                this.parameters.put(entry.getKey(), Arrays.asList(entry.getValue()));
            }
        }
        while ((part = parser.readNextPart()) != null) {
            String name = part.getName();
            if (name == null) {
                throw new IOException("Malformed input: parameter name missing (known Opera 7 bug)");
            }
            if (part.isParam()) {
                ParamPart paramPart = (ParamPart)part;
                String value = paramPart.getStringValue();
                List<String> existingValues = this.parameters.get(name);
                if (existingValues == null) {
                    existingValues = new ArrayList<String>();
                    this.parameters.put(name, existingValues);
                }
                existingValues.add(value);
                continue;
            }
            if (!part.isFile()) continue;
            FilePart filePart = (FilePart)part;
            String fileName = filePart.getFileName();
            if (fileName != null) {
                filePart.setRenamePolicy(policy);
                filePart.writeTo(dir);
                this.files.put(name, new UploadedFile(dir.toString(), filePart.getFileName(), fileName, filePart.getContentType()));
                continue;
            }
            this.files.put(name, new UploadedFile(null, null, null, null));
        }
    }

    public CosMultipartRequest(ServletRequest request, String saveDirectory) throws IOException {
        this((HttpServletRequest)request, saveDirectory);
    }

    public CosMultipartRequest(ServletRequest request, String saveDirectory, int maxPostSize) throws IOException {
        this((HttpServletRequest)request, saveDirectory, maxPostSize);
    }

    public Enumeration<String> getParameterNames() {
        return this.parameters.keys();
    }

    public Set<String> getFileNames() {
        return this.files.keySet();
    }

    public String getParameter(String name) {
        List<String> values;
        block3: {
            try {
                values = this.parameters.get(name);
                if (values != null && values.size() != 0) break block3;
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
        return values.get(values.size() - 1);
    }

    public String[] getParameterValues(String name) {
        List<String> values = this.parameters.get(name);
        if (values == null || values.size() == 0) {
            return null;
        }
        return values.toArray(new String[values.size()]);
    }

    public String getFilesystemName(String name) {
        try {
            UploadedFile file = this.files.get(name);
            return file.getFilesystemName();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getOriginalFileName(String name) {
        try {
            UploadedFile file = this.files.get(name);
            return file.getOriginalFileName();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getContentType(String name) {
        try {
            UploadedFile file = this.files.get(name);
            return file.getContentType();
        }
        catch (Exception e) {
            return null;
        }
    }

    public File getFile(String name) {
        try {
            UploadedFile file = this.files.get(name);
            return file.getFile();
        }
        catch (Exception e) {
            return null;
        }
    }
}

