/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.common.web.cos;

import com.jeecms.common.web.cos.BufferedServletInputStream;
import com.jeecms.common.web.cos.FilePart;
import com.jeecms.common.web.cos.LimitedServletInputStream;
import com.jeecms.common.web.cos.ParamPart;
import com.jeecms.common.web.cos.Part;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;

public class MultipartParser {
    private ServletInputStream in;
    private String boundary;
    private FilePart lastFilePart;
    private byte[] buf = new byte[8192];
    private static String DEFAULT_ENCODING = "ISO-8859-1";
    private String encoding = DEFAULT_ENCODING;

    public MultipartParser(HttpServletRequest req, int maxSize) throws IOException {
        this(req, maxSize, true, true);
    }

    public MultipartParser(HttpServletRequest req, int maxSize, boolean buffer, boolean limitLength) throws IOException {
        this(req, maxSize, buffer, limitLength, null);
    }

    public MultipartParser(HttpServletRequest req, int maxSize, boolean buffer, boolean limitLength, String encoding) throws IOException {
        String line;
        if (encoding != null) {
            this.setEncoding(encoding);
        }
        String type = null;
        String type1 = req.getHeader("Content-Type");
        String type2 = req.getContentType();
        if (type1 == null && type2 != null) {
            type = type2;
        } else if (type2 == null && type1 != null) {
            type = type1;
        } else if (type1 != null && type2 != null) {
            String string = type = type1.length() > type2.length() ? type1 : type2;
        }
        if (type == null || !type.toLowerCase().startsWith("multipart/form-data")) {
            throw new IOException("Posted content type isn't multipart/form-data");
        }
        int length = req.getContentLength();
        if (length > maxSize) {
            throw new IOException("Posted content length of " + length + " exceeds limit of " + maxSize);
        }
        String boundary = this.extractBoundary(type);
        if (boundary == null) {
            throw new IOException("Separation boundary was not specified");
        }
        ServletInputStream in = req.getInputStream();
        if (buffer) {
            in = new BufferedServletInputStream(in);
        }
        if (limitLength && length > 0) {
            in = new LimitedServletInputStream(in, length);
        }
        this.in = in;
        this.boundary = boundary;
        do {
            if ((line = this.readLine()) != null) continue;
            throw new IOException("Corrupt form data: premature ending");
        } while (!line.startsWith(boundary));
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    /*
     * Unable to fully structure code
     */
    public Part readNextPart() throws IOException {
        if (this.lastFilePart != null) {
            this.lastFilePart.getInputStream().close();
            this.lastFilePart = null;
        }
        headers = new ArrayList<String>();
        line = this.readLine();
        if (line == null) {
            return null;
        }
        if (line.length() != 0) ** GOTO lbl22
        return null;
lbl-1000:
        // 1 sources

        {
            nextLine = null;
            getNextLine = true;
            while (getNextLine) {
                nextLine = this.readLine();
                if (nextLine != null && (nextLine.startsWith(" ") || nextLine.startsWith("\t"))) {
                    line = String.valueOf(line) + nextLine;
                    continue;
                }
                getNextLine = false;
            }
            headers.add(line);
            line = nextLine;
lbl22:
            // 2 sources

            ** while (line != null && line.length() > 0)
        }
lbl23:
        // 1 sources

        if (line == null) {
            return null;
        }
        name = null;
        filename = null;
        origname = null;
        contentType = "text/plain";
        for (String headerline : headers) {
            if (headerline.toLowerCase().startsWith("content-disposition:")) {
                dispInfo = this.extractDispositionInfo(headerline);
                name = dispInfo[1];
                filename = dispInfo[2];
                origname = dispInfo[3];
                continue;
            }
            if (!headerline.toLowerCase().startsWith("content-type:") || (type = MultipartParser.extractContentType(headerline)) == null) continue;
            contentType = type;
        }
        if (filename == null) {
            return new ParamPart(name, this.in, this.boundary, this.encoding);
        }
        if (filename.equals("")) {
            filename = null;
        }
        this.lastFilePart = new FilePart(name, this.in, this.boundary, contentType, filename, origname);
        return this.lastFilePart;
    }

    private String extractBoundary(String line) {
        int index = line.lastIndexOf("boundary=");
        if (index == -1) {
            return null;
        }
        String boundary = line.substring(index + 9);
        if (boundary.charAt(0) == '\"') {
            index = boundary.lastIndexOf(34);
            boundary = boundary.substring(1, index);
        }
        boundary = "--" + boundary;
        return boundary;
    }

    private String[] extractDispositionInfo(String line) throws IOException {
        String[] retval = new String[4];
        String origline = line;
        line = origline.toLowerCase();
        int start = line.indexOf("content-disposition: ");
        int end = line.indexOf(";");
        if (start == -1 || end == -1) {
            throw new IOException("Content disposition corrupt: " + origline);
        }
        String disposition = line.substring(start + 21, end).trim();
        if (!disposition.equals("form-data")) {
            throw new IOException("Invalid content disposition: " + disposition);
        }
        start = line.indexOf("name=\"", end);
        end = line.indexOf("\"", start + 7);
        int startOffset = 6;
        if (start == -1 || end == -1) {
            start = line.indexOf("name=", end);
            end = line.indexOf(";", start + 6);
            if (start == -1) {
                throw new IOException("Content disposition corrupt: " + origline);
            }
            if (end == -1) {
                end = line.length();
            }
            startOffset = 5;
        }
        String name = origline.substring(start + startOffset, end);
        String filename = null;
        String origname = null;
        start = line.indexOf("filename=\"", end + 2);
        end = line.indexOf("\"", start + 10);
        if (start != -1 && end != -1) {
            origname = filename = origline.substring(start + 10, end);
            int slash = Math.max(filename.lastIndexOf(47), filename.lastIndexOf(92));
            if (slash > -1) {
                filename = filename.substring(slash + 1);
            }
        }
        retval[0] = disposition;
        retval[1] = name;
        retval[2] = filename;
        retval[3] = origname;
        return retval;
    }

    private static String extractContentType(String line) throws IOException {
        int end = (line = line.toLowerCase()).indexOf(";");
        if (end == -1) {
            end = line.length();
        }
        return line.substring(13, end).trim();
    }

    private String readLine() throws IOException {
        int result;
        StringBuffer sbuf = new StringBuffer();
        do {
            if ((result = this.in.readLine(this.buf, 0, this.buf.length)) == -1) continue;
            sbuf.append(new String(this.buf, 0, result, this.encoding));
        } while (result == this.buf.length);
        if (sbuf.length() == 0) {
            return null;
        }
        int len = sbuf.length();
        if (len >= 2 && sbuf.charAt(len - 2) == '\r') {
            sbuf.setLength(len - 2);
        } else if (len >= 1 && sbuf.charAt(len - 1) == '\n') {
            sbuf.setLength(len - 1);
        }
        return sbuf.toString();
    }
}

