/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.common.web.freemarker;

import com.jeecms.common.web.freemarker.MustBooleanException;
import com.jeecms.common.web.freemarker.MustDateException;
import com.jeecms.common.web.freemarker.MustNumberException;
import com.jeecms.common.web.freemarker.MustSplitNumberException;
import com.jeecms.common.web.freemarker.MustStringException;
import com.jeecms.common.web.springmvc.DateTypeEditor;
import freemarker.core.Environment;
import freemarker.template.AdapterTemplateModel;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateDateModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.servlet.support.RequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DirectiveUtils {
    public static final String OUT_BEAN = "tag_bean";
    public static final String OUT_LIST = "tag_list";
    public static final String OUT_PAGINATION = "tag_pagination";
    public static final String PARAM_TPL = "tpl";
    public static final String PARAM_TPL_SUB = "tplSub";

    public static Map<String, TemplateModel> addParamsToVariable(Environment env, Map<String, TemplateModel> params) throws TemplateException {
        HashMap<String, TemplateModel> origMap = new HashMap<String, TemplateModel>();
        if (params.size() <= 0) {
            return origMap;
        }
        Set<Map.Entry<String, TemplateModel>> entrySet = params.entrySet();
        for (Map.Entry<String, TemplateModel> entry : entrySet) {
            String key = entry.getKey();
            TemplateModel value = env.getVariable(key);
            if (value != null) {
                origMap.put(key, value);
            }
            env.setVariable(key, entry.getValue());
        }
        return origMap;
    }

    public static void removeParamsFromVariable(Environment env, Map<String, TemplateModel> params, Map<String, TemplateModel> origMap) throws TemplateException {
        if (params.size() <= 0) {
            return;
        }
        for (String key : params.keySet()) {
            env.setVariable(key, origMap.get(key));
        }
    }

    public static RequestContext getContext(Environment env) throws TemplateException {
        TemplateModel ctx = env.getGlobalVariable("springMacroRequestContext");
        if (ctx instanceof AdapterTemplateModel) {
            return (RequestContext)((AdapterTemplateModel)ctx).getAdaptedObject(RequestContext.class);
        }
        throw new TemplateModelException("RequestContext 'springMacroRequestContext' not found in DataModel.");
    }

    public static String getString(String name, Map<String, TemplateModel> params) throws TemplateException {
        TemplateModel model = params.get(name);
        if (model == null) {
            return null;
        }
        if (model instanceof TemplateScalarModel) {
            return ((TemplateScalarModel)model).getAsString();
        }
        if (model instanceof TemplateNumberModel) {
            return ((TemplateNumberModel)model).getAsNumber().toString();
        }
        throw new MustStringException(name);
    }

    public static Long getLong(String name, Map<String, TemplateModel> params) throws TemplateException {
        TemplateModel model = params.get(name);
        if (model == null) {
            return null;
        }
        if (model instanceof TemplateScalarModel) {
            String s = ((TemplateScalarModel)model).getAsString();
            if (StringUtils.isBlank((String)s)) {
                return null;
            }
            try {
                return Long.parseLong(s);
            }
            catch (NumberFormatException e) {
                throw new MustNumberException(name);
            }
        }
        if (model instanceof TemplateNumberModel) {
            return ((TemplateNumberModel)model).getAsNumber().longValue();
        }
        throw new MustNumberException(name);
    }

    public static Integer getInt(String name, Map<String, TemplateModel> params) throws TemplateException {
        TemplateModel model = params.get(name);
        if (model == null) {
            return null;
        }
        if (model instanceof TemplateScalarModel) {
            String s = ((TemplateScalarModel)model).getAsString();
            if (StringUtils.isBlank((String)s)) {
                return null;
            }
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                throw new MustNumberException(name);
            }
        }
        if (model instanceof TemplateNumberModel) {
            return ((TemplateNumberModel)model).getAsNumber().intValue();
        }
        throw new MustNumberException(name);
    }

    public static Integer[] getIntArray(String name, Map<String, TemplateModel> params) throws TemplateException {
        String str = DirectiveUtils.getString(name, params);
        if (StringUtils.isBlank((String)str)) {
            return null;
        }
        String[] arr = StringUtils.split((String)str, (char)',');
        Integer[] ids = new Integer[arr.length];
        int i = 0;
        try {
            String[] stringArray = arr;
            int n = arr.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                ids[i++] = Integer.valueOf(s);
                ++n2;
            }
            return ids;
        }
        catch (NumberFormatException e) {
            throw new MustSplitNumberException(name, e);
        }
    }

    public static Boolean getBool(String name, Map<String, TemplateModel> params) throws TemplateException {
        TemplateModel model = params.get(name);
        if (model == null) {
            return null;
        }
        if (model instanceof TemplateBooleanModel) {
            return ((TemplateBooleanModel)model).getAsBoolean();
        }
        if (model instanceof TemplateNumberModel) {
            return ((TemplateNumberModel)model).getAsNumber().intValue() != 0;
        }
        if (model instanceof TemplateScalarModel) {
            String s = ((TemplateScalarModel)model).getAsString();
            if (!StringUtils.isBlank((String)s)) {
                return !s.equals("0") && !s.equalsIgnoreCase("false") && !s.equalsIgnoreCase("f");
            }
            return null;
        }
        throw new MustBooleanException(name);
    }

    public static Date getDate(String name, Map<String, TemplateModel> params) throws TemplateException {
        TemplateModel model = params.get(name);
        if (model == null) {
            return null;
        }
        if (model instanceof TemplateDateModel) {
            return ((TemplateDateModel)model).getAsDate();
        }
        if (model instanceof TemplateScalarModel) {
            DateTypeEditor editor = new DateTypeEditor();
            editor.setAsText(((TemplateScalarModel)model).getAsString());
            return (Date)editor.getValue();
        }
        throw new MustDateException(name);
    }

    public static InvokeType getInvokeType(Map<String, TemplateModel> params) throws TemplateException {
        String tpl = DirectiveUtils.getString(PARAM_TPL, params);
        if ("3".equals(tpl)) {
            return InvokeType.userDefined;
        }
        if ("2".equals(tpl)) {
            return InvokeType.sysDefined;
        }
        if ("1".equals(tpl)) {
            return InvokeType.custom;
        }
        return InvokeType.body;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InvokeType {
        body,
        custom,
        sysDefined,
        userDefined;

    }
}

