/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.common.web.freemarker;

import com.jeecms.common.web.freemarker.MustNumberException;
import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNumberModel;
import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessTimeDirective
implements TemplateDirectiveModel {
    private static final Logger log = LoggerFactory.getLogger(ProcessTimeDirective.class);
    private static final DecimalFormat FORMAT = new DecimalFormat("0.000");

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        long time = this.getStartTime(env);
        if (time != -1L) {
            time = System.currentTimeMillis() - time;
            Writer out = env.getOut();
            out.append("Processed in " + FORMAT.format((float)time / 1000.0f) + " second(s)");
        }
    }

    private long getStartTime(Environment env) throws TemplateModelException {
        TemplateModel startTime = env.getGlobalVariable("_start_time");
        if (startTime == null) {
            log.warn("Variable '{}' not found in GlobalVariable", (Object)"_start_time");
            return -1L;
        }
        if (startTime instanceof TemplateNumberModel) {
            return ((TemplateNumberModel)startTime).getAsNumber().longValue();
        }
        throw new MustNumberException("_start_time");
    }
}

