/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.common.web.session.cache;

import com.danga.MemCached.MemCachedClient;
import com.danga.MemCached.SockIOPool;
import com.jeecms.common.web.session.cache.SessionCache;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemcachedDangaCache
implements SessionCache,
InitializingBean {
    private MemCachedClient client;
    private String[] servers;
    private Integer[] weights;

    public HashMap<String, Serializable> getSession(String root) {
        return (HashMap)this.client.get(root);
    }

    @Override
    public void setSession(String root, Map<String, Serializable> session, int exp) {
        this.client.set(root, session, new Date(System.currentTimeMillis() + (long)(exp * 60 * 1000)));
    }

    @Override
    public Serializable getAttribute(String root, String name) {
        Map session = this.getSession(root);
        return session != null ? (Serializable)((HashMap)session).get(name) : null;
    }

    @Override
    public void setAttribute(String root, String name, Serializable value, int exp) {
        HashMap<String, Serializable> session = this.getSession(root);
        if (session == null) {
            session = new HashMap<String, Serializable>();
        }
        session.put(name, value);
        Date expDate = new Date(System.currentTimeMillis() + (long)(exp * 60 * 1000));
        this.client.set(root, session, expDate);
    }

    @Override
    public void clear(String root) {
        this.client.delete(root);
    }

    @Override
    public boolean exist(String root) {
        return this.client.keyExists(root);
    }

    public void afterPropertiesSet() throws Exception {
        this.client = new MemCachedClient();
        SockIOPool pool = SockIOPool.getInstance();
        pool.setServers(this.servers);
        pool.setWeights(this.weights);
        pool.setInitConn(5);
        pool.setMinConn(5);
        pool.setMaxConn(250);
        pool.setMaxIdle(21600000L);
        pool.setMaintSleep(30L);
        pool.setNagle(false);
        pool.setSocketTO(3000);
        pool.setSocketConnectTO(0);
        pool.initialize();
        this.client.setCompressEnable(true);
        this.client.setCompressThreshold(65536L);
    }

    public String[] getServers() {
        return this.servers;
    }

    public void setServers(String[] servers) {
        this.servers = servers;
    }

    public Integer[] getWeights() {
        return this.weights;
    }

    public void setWeights(Integer[] weights) {
        this.weights = weights;
    }
}

