/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.common.web.session.cache;

import com.jeecms.common.web.session.cache.SessionCache;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.spy.memcached.MemcachedClient;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemcachedSpyCache
implements SessionCache,
InitializingBean,
DisposableBean {
    private MemcachedClient client;
    private String[] servers;
    private Integer[] weights;

    public HashMap<String, Serializable> getSession(String root) {
        return (HashMap)this.client.get(root);
    }

    @Override
    public void setSession(String root, Map<String, Serializable> session, int exp) {
        this.client.set(root, exp * 60, session);
    }

    @Override
    public Serializable getAttribute(String root, String name) {
        Map session = this.getSession(root);
        return session != null ? (Serializable)((HashMap)session).get(name) : null;
    }

    @Override
    public void setAttribute(String root, String name, Serializable value, int exp) {
        HashMap<String, Serializable> session = this.getSession(root);
        if (session == null) {
            session = new HashMap<String, Serializable>();
        }
        session.put(name, value);
        this.client.set(root, exp * 60, session);
    }

    @Override
    public void clear(String root) {
        this.client.delete(root);
    }

    @Override
    public boolean exist(String root) {
        return this.client.get(root) != null;
    }

    public void afterPropertiesSet() throws Exception {
        ArrayList<InetSocketAddress> addr = new ArrayList<InetSocketAddress>(this.servers.length);
        String[] stringArray = this.servers;
        int n = this.servers.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            int index = s.indexOf(":");
            addr.add(new InetSocketAddress(s.substring(0, index), Integer.parseInt(s.substring(index + 1))));
            ++n2;
        }
        this.client = new MemcachedClient(addr);
    }

    public void destroy() throws Exception {
        this.client.shutdown();
    }

    public String[] getServers() {
        return this.servers;
    }

    public void setServers(String[] servers) {
        this.servers = servers;
    }

    public Integer[] getWeights() {
        return this.weights;
    }

    public void setWeights(Integer[] weights) {
        this.weights = weights;
    }
}

