/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.common.web.springmvc;

import freemarker.core.ParseException;
import freemarker.template.Configuration;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContextException;
import org.springframework.web.servlet.view.AbstractTemplateView;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfig;

public class SimpleFreeMarkerView
extends AbstractTemplateView {
    public static final String CONTEXT_PATH = "base";
    private Configuration configuration;

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    protected FreeMarkerConfig autodetectConfiguration() throws BeansException {
        try {
            return (FreeMarkerConfig)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)this.getApplicationContext(), FreeMarkerConfig.class, (boolean)true, (boolean)false);
        }
        catch (NoSuchBeanDefinitionException ex) {
            throw new ApplicationContextException("Must define a single FreeMarkerConfig bean in this web application context (may be inherited): FreeMarkerConfigurer is the usual implementation. This bean may be given any name.", (Throwable)ex);
        }
    }

    protected void initApplicationContext() throws BeansException {
        super.initApplicationContext();
        if (this.getConfiguration() == null) {
            FreeMarkerConfig config = this.autodetectConfiguration();
            this.setConfiguration(config.getConfiguration());
        }
        this.checkTemplate();
    }

    protected void checkTemplate() throws ApplicationContextException {
        try {
            this.getConfiguration().getTemplate(this.getUrl());
        }
        catch (ParseException ex) {
            throw new ApplicationContextException("Failed to parse FreeMarker template for URL [" + this.getUrl() + "]", (Throwable)ex);
        }
        catch (IOException ex) {
            throw new ApplicationContextException("Could not load FreeMarker template for URL [" + this.getUrl() + "]", (Throwable)ex);
        }
    }

    protected void renderMergedTemplateModel(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        model.put(CONTEXT_PATH, request.getContextPath());
        this.getConfiguration().getTemplate(this.getUrl()).process((Object)model, (Writer)response.getWriter());
    }
}

