/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.admin;

import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.entity.main.MarkConfig;
import com.jeecms.cms.web.CmsUtils;
import com.jeecms.common.fck.Command;
import com.jeecms.common.fck.ResourceType;
import com.jeecms.common.fck.UploadResponse;
import com.jeecms.common.fck.Utils;
import com.jeecms.common.image.ImageScale;
import com.jeecms.common.image.ImageUtils;
import com.jeecms.common.upload.FileRepository;
import com.jeecms.common.upload.UploadUtils;
import com.jeecms.common.web.springmvc.RealPathResolver;
import com.jeecms.core.entity.Ftp;
import com.jeecms.core.manager.DbFileMng;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
public class FckAct {
    private static final Logger log = LoggerFactory.getLogger(FckAct.class);
    private FileRepository fileRepository;
    private DbFileMng dbFileMng;
    private ImageScale imageScale;
    private RealPathResolver realPathResolver;

    @RequestMapping(value={"/fck/upload.do"}, method={RequestMethod.POST})
    public void upload(@RequestParam(value="Command", required=false) String commandStr, @RequestParam(value="Type", required=false) String typeStr, @RequestParam(value="CurrentFolder", required=false) String currentFolderStr, @RequestParam(value="mark", required=false) Boolean mark, HttpServletRequest request, HttpServletResponse response) throws Exception {
        log.debug("Entering Dispatcher#doPost");
        this.responseInit(response);
        if (Utils.isEmpty((String)commandStr) && Utils.isEmpty((String)currentFolderStr)) {
            commandStr = "QuickUpload";
            currentFolderStr = "/";
            if (Utils.isEmpty((String)typeStr)) {
                typeStr = "File";
            }
        }
        if (currentFolderStr != null && !currentFolderStr.startsWith("/")) {
            currentFolderStr = "/".concat(currentFolderStr);
        }
        log.debug("Parameter Command: {}", (Object)commandStr);
        log.debug("Parameter Type: {}", (Object)typeStr);
        log.debug("Parameter CurrentFolder: {}", (Object)currentFolderStr);
        UploadResponse ur = this.validateUpload(request, commandStr, typeStr, currentFolderStr);
        if (ur == null) {
            ur = this.doUpload(request, typeStr, currentFolderStr, mark);
        }
        PrintWriter out = response.getWriter();
        out.print(ur);
        out.flush();
        out.close();
    }

    private UploadResponse doUpload(HttpServletRequest request, String typeStr, String currentFolderStr, Boolean mark) throws Exception {
        ResourceType type = ResourceType.getDefaultResourceType((String)typeStr);
        try {
            String fileUrl;
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
            MultipartFile uplFile = (MultipartFile)multipartRequest.getFileMap().entrySet().iterator().next().getValue();
            String filename = FilenameUtils.getName((String)uplFile.getOriginalFilename());
            log.debug("Parameter NewFile: {}", (Object)filename);
            String ext = FilenameUtils.getExtension((String)filename);
            if (type.isDeniedExtension(ext)) {
                return UploadResponse.getInvalidFileTypeError((HttpServletRequest)request);
            }
            if (type.equals((Object)ResourceType.IMAGE) && !ImageUtils.isImage((InputStream)uplFile.getInputStream())) {
                return UploadResponse.getInvalidFileTypeError((HttpServletRequest)request);
            }
            CmsSite site = CmsUtils.getSite(request);
            MarkConfig conf = site.getConfig().getMarkConfig();
            if (mark == null) {
                mark = conf.getOn();
            }
            boolean isImg = type.equals((Object)ResourceType.IMAGE);
            if (site.getConfig().getUploadToDb().booleanValue()) {
                if (mark.booleanValue() && isImg) {
                    File tempFile = this.mark(uplFile, conf);
                    fileUrl = this.dbFileMng.storeByExt(site.getUploadPath(), ext, (InputStream)new FileInputStream(tempFile));
                    tempFile.delete();
                } else {
                    fileUrl = this.dbFileMng.storeByExt(site.getUploadPath(), ext, uplFile.getInputStream());
                }
                String dbFilePath = site.getConfig().getDbFileUri();
                fileUrl = String.valueOf(request.getContextPath()) + dbFilePath + fileUrl;
            } else if (site.getUploadFtp() != null) {
                Ftp ftp = site.getUploadFtp();
                if (mark.booleanValue() && isImg) {
                    File tempFile = this.mark(uplFile, conf);
                    fileUrl = ftp.storeByExt(site.getUploadPath(), ext, (InputStream)new FileInputStream(tempFile));
                    tempFile.delete();
                } else {
                    fileUrl = ftp.storeByExt(site.getUploadPath(), ext, uplFile.getInputStream());
                }
                fileUrl = String.valueOf(ftp.getUrl()) + fileUrl;
            } else {
                if (mark.booleanValue() && isImg) {
                    File tempFile = this.mark(uplFile, conf);
                    fileUrl = this.fileRepository.storeByExt(site.getUploadPath(), ext, tempFile);
                    tempFile.delete();
                } else {
                    fileUrl = this.fileRepository.storeByExt(site.getUploadPath(), ext, uplFile);
                }
                fileUrl = String.valueOf(request.getContextPath()) + fileUrl;
            }
            return UploadResponse.getOK((HttpServletRequest)request, (String)fileUrl);
        }
        catch (IOException e) {
            return UploadResponse.getFileUploadWriteError((HttpServletRequest)request);
        }
    }

    private void responseInit(HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/html");
        response.setHeader("Cache-Control", "no-cache");
    }

    private UploadResponse validateUpload(HttpServletRequest request, String commandStr, String typeStr, String currentFolderStr) {
        if (!Command.isValidForPost((String)commandStr)) {
            return UploadResponse.getInvalidCommandError((HttpServletRequest)request);
        }
        if (!ResourceType.isValidType((String)typeStr)) {
            return UploadResponse.getInvalidResourceTypeError((HttpServletRequest)request);
        }
        if (!UploadUtils.isValidPath((String)currentFolderStr)) {
            return UploadResponse.getInvalidCurrentFolderError((HttpServletRequest)request);
        }
        return null;
    }

    private File mark(MultipartFile file, MarkConfig conf) throws Exception {
        boolean imgMark;
        String path = System.getProperty("java.io.tmpdir");
        File tempFile = new File(path, String.valueOf(System.currentTimeMillis()));
        file.transferTo(tempFile);
        boolean bl = imgMark = !StringUtils.isBlank((String)conf.getImagePath());
        if (imgMark) {
            File markImg = new File(this.realPathResolver.get(conf.getImagePath()));
            this.imageScale.imageMark(tempFile, tempFile, conf.getMinWidth().intValue(), conf.getMinHeight().intValue(), conf.getPos().intValue(), conf.getOffsetX().intValue(), conf.getOffsetY().intValue(), markImg);
        } else {
            this.imageScale.imageMark(tempFile, tempFile, conf.getMinWidth().intValue(), conf.getMinHeight().intValue(), conf.getPos().intValue(), conf.getOffsetX().intValue(), conf.getOffsetY().intValue(), conf.getContent(), Color.decode(conf.getColor()), conf.getSize().intValue(), conf.getAlpha().intValue());
        }
        return tempFile;
    }

    @Autowired
    public void setFileRepository(FileRepository fileRepository) {
        this.fileRepository = fileRepository;
    }

    @Autowired
    public void setDbFileMng(DbFileMng dbFileMng) {
        this.dbFileMng = dbFileMng;
    }

    @Autowired
    public void setImageScale(ImageScale imageScale) {
        this.imageScale = imageScale;
    }

    @Autowired
    public void setRealPathResolver(RealPathResolver realPathResolver) {
        this.realPathResolver = realPathResolver;
    }
}

