/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.admin;

import com.jeecms.cms.entity.main.CmsUser;
import com.jeecms.cms.entity.main.CmsUserExt;
import com.jeecms.cms.manager.main.CmsUserExtMng;
import com.jeecms.cms.manager.main.CmsUserMng;
import com.jeecms.cms.web.CmsUtils;
import com.jeecms.cms.web.WebErrors;
import com.jeecms.common.web.ResponseUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class PersonalAct {
    @Autowired
    private CmsUserMng cmsUserMng;
    @Autowired
    private CmsUserExtMng cmsUserExtMng;

    @RequestMapping(value={"/personal/v_profile.do"})
    public String profileEdit(HttpServletRequest request, ModelMap model) {
        CmsUser user = CmsUtils.getUser(request);
        model.addAttribute("user", (Object)user);
        return "personal/profile";
    }

    @RequestMapping(value={"/personal/o_profile.do"})
    public String profileUpdate(String origPwd, String newPwd, String email, String realname, HttpServletRequest request, ModelMap model) {
        CmsUser user = CmsUtils.getUser(request);
        WebErrors errors = this.validatePasswordSubmit((Integer)user.getId(), origPwd, newPwd, email, realname, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        CmsUserExt ext = user.getUserExt();
        if (ext == null) {
            ext = new CmsUserExt();
        }
        ext.setRealname(realname);
        this.cmsUserExtMng.update(ext, user);
        this.cmsUserMng.updatePwdEmail((Integer)user.getId(), newPwd, email);
        model.addAttribute("message", (Object)"global.success");
        return this.profileEdit(request, model);
    }

    @RequestMapping(value={"/personal/v_checkPwd.do"})
    public void checkPwd(String origPwd, HttpServletRequest request, HttpServletResponse response) {
        CmsUser user = CmsUtils.getUser(request);
        boolean pass = this.cmsUserMng.isPasswordValid((Integer)user.getId(), origPwd);
        ResponseUtils.renderJson((HttpServletResponse)response, (String)(pass ? "true" : "false"));
    }

    private WebErrors validatePasswordSubmit(Integer id, String origPwd, String newPwd, String email, String realname, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        if (errors.ifBlank(origPwd, "origPwd", 32)) {
            return errors;
        }
        if (errors.ifMaxLength(newPwd, "newPwd", 32)) {
            return errors;
        }
        if (errors.ifMaxLength(email, "email", 100)) {
            return errors;
        }
        if (errors.ifMaxLength(realname, "realname", 100)) {
            return errors;
        }
        if (!this.cmsUserMng.isPasswordValid(id, origPwd)) {
            errors.addErrorCode("member.origPwdInvalid");
            return errors;
        }
        return errors;
    }
}

