/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.admin.assist;

import com.jeecms.cms.entity.assist.CmsAcquisition;
import com.jeecms.cms.entity.assist.CmsAcquisitionHistory;
import com.jeecms.cms.entity.assist.CmsAcquisitionTemp;
import com.jeecms.cms.entity.main.Channel;
import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.entity.main.ContentType;
import com.jeecms.cms.manager.assist.CmsAcquisitionHistoryMng;
import com.jeecms.cms.manager.assist.CmsAcquisitionMng;
import com.jeecms.cms.manager.assist.CmsAcquisitionTempMng;
import com.jeecms.cms.manager.main.ChannelMng;
import com.jeecms.cms.manager.main.CmsLogMng;
import com.jeecms.cms.manager.main.ContentTypeMng;
import com.jeecms.cms.service.AcquisitionSvc;
import com.jeecms.cms.web.CmsUtils;
import com.jeecms.cms.web.WebErrors;
import com.jeecms.common.page.Pagination;
import com.jeecms.common.page.SimplePage;
import com.jeecms.common.web.CookieUtils;
import com.jeecms.common.web.ResponseUtils;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class CmsAcquisitionAct {
    private static final Logger log = LoggerFactory.getLogger(CmsAcquisitionAct.class);
    @Autowired
    private ContentTypeMng contentTypeMng;
    @Autowired
    private ChannelMng channelMng;
    @Autowired
    private AcquisitionSvc acquisitionSvc;
    @Autowired
    private CmsLogMng cmsLogMng;
    @Autowired
    private CmsAcquisitionMng manager;
    @Autowired
    private CmsAcquisitionHistoryMng cmsAcquisitionHistoryMng;
    @Autowired
    private CmsAcquisitionTempMng cmsAcquisitionTempMng;

    @RequestMapping(value={"/acquisition/v_list.do"})
    public String list(HttpServletRequest request, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        List<CmsAcquisition> list = this.manager.getList(site.getId());
        model.addAttribute("list", list);
        return "acquisition/list";
    }

    @RequestMapping(value={"/acquisition/v_add.do"})
    public String add(HttpServletRequest request, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        List<ContentType> typeList = this.contentTypeMng.getList(false);
        List<Channel> topList = this.channelMng.getTopList(site.getId(), true);
        List<Channel> channelList = Channel.getListForSelect(topList, null, true);
        model.addAttribute("channelList", channelList);
        model.addAttribute("typeList", typeList);
        return "acquisition/add";
    }

    @RequestMapping(value={"/acquisition/v_edit.do"})
    public String edit(Integer id, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        CmsSite site = CmsUtils.getSite(request);
        List<ContentType> typeList = this.contentTypeMng.getList(false);
        List<Channel> topList = this.channelMng.getTopList(site.getId(), true);
        List<Channel> channelList = Channel.getListForSelect(topList, null, true);
        model.addAttribute("channelList", channelList);
        model.addAttribute("typeList", typeList);
        model.addAttribute("cmsAcquisition", (Object)this.manager.findById(id));
        return "acquisition/edit";
    }

    @RequestMapping(value={"/acquisition/o_save.do"})
    public String save(CmsAcquisition bean, Integer channelId, Integer typeId, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateSave(bean, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        Integer siteId = CmsUtils.getSiteId(request);
        Integer userId = CmsUtils.getUserId(request);
        bean = this.manager.save(bean, channelId, typeId, userId, siteId);
        log.info("save CmsAcquisition id={}", (Object)bean.getId());
        this.cmsLogMng.operating(request, "cmsAcquisition.log.save", "id=" + bean.getId() + ";name=" + bean.getName());
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/acquisition/o_update.do"})
    public String update(CmsAcquisition bean, Integer channelId, Integer typeId, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateUpdate(bean.getId(), request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.update(bean, channelId, typeId);
        log.info("update CmsAcquisition id={}.", (Object)bean.getId());
        this.cmsLogMng.operating(request, "cmsAcquisition.log.update", "id=" + bean.getId() + ";name=" + bean.getName());
        return this.list(request, model);
    }

    @RequestMapping(value={"/acquisition/o_delete.do"})
    public String delete(Integer[] ids, HttpServletRequest request, ModelMap model) {
        CmsAcquisition[] beans;
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        CmsAcquisition[] cmsAcquisitionArray = beans = this.manager.deleteByIds(ids);
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            CmsAcquisition bean = cmsAcquisitionArray[n2];
            log.info("delete CmsAcquisition id={}", (Object)bean.getId());
            this.cmsLogMng.operating(request, "cmsAcquisition.log.delete", "id=" + bean.getId() + ";name=" + bean.getName());
            ++n2;
        }
        return this.list(request, model);
    }

    @RequestMapping(value={"/acquisition/o_start.do"})
    public String start(Integer[] ids, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        Integer siteId = CmsUtils.getSiteId(request);
        WebErrors errors = this.validateStart(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        Integer queueNum = this.manager.hasStarted(siteId);
        if (queueNum == 0) {
            this.acquisitionSvc.start(ids[0]);
        }
        this.manager.addToQueue(ids, queueNum);
        log.info("start CmsAcquisition ids={}", (Object)Arrays.toString((Object[])ids));
        return "acquisition/progress";
    }

    @RequestMapping(value={"/acquisition/o_end.do"})
    public String end(Integer id, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        WebErrors errors = WebErrors.create(request);
        Integer siteId = CmsUtils.getSiteId(request);
        if (this.vldExist(id, siteId, errors)) {
            return errors.showErrorPage(model);
        }
        this.manager.end(id);
        CmsAcquisition acqu = this.manager.popAcquFromQueue(siteId);
        if (acqu != null) {
            Integer acquId = acqu.getId();
            this.acquisitionSvc.start(acquId);
        }
        log.info("end CmsAcquisition id={}", (Object)id);
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/acquisition/o_pause.do"})
    public String pause(Integer id, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        WebErrors errors = WebErrors.create(request);
        Integer siteId = CmsUtils.getSiteId(request);
        if (this.vldExist(id, siteId, errors)) {
            return errors.showErrorPage(model);
        }
        this.manager.pause(id);
        log.info("pause CmsAcquisition id={}", (Object)id);
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/acquisition/o_cancel.do"})
    public String cancel(Integer id, Integer sortId, Integer pageNo, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        WebErrors errors = WebErrors.create(request);
        Integer siteId = CmsUtils.getSiteId(request);
        if (this.vldExist(id, siteId, errors)) {
            return errors.showErrorPage(model);
        }
        this.manager.cancel(siteId, id);
        log.info("cancel CmsAcquisition id={}", (Object)id);
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/acquisition/v_check_complete.do"})
    public void checkComplete(Integer id, HttpServletRequest request, HttpServletResponse response, ModelMap model) throws JSONException {
        JSONObject json = new JSONObject();
        CmsSite site = CmsUtils.getSite(request);
        Integer siteId = site.getId();
        CmsAcquisition acqu = this.manager.getStarted(siteId);
        json.put("completed", acqu == null);
        ResponseUtils.renderJson((HttpServletResponse)response, (String)json.toString());
    }

    @RequestMapping(value={"/acquisition/v_progress_data.do"})
    public String progressData(Integer id, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        Integer siteId = site.getId();
        CmsAcquisition acqu = this.manager.getStarted(siteId);
        List<CmsAcquisitionTemp> list = this.cmsAcquisitionTempMng.getList(siteId);
        model.put((Object)"percent", (Object)this.cmsAcquisitionTempMng.getPercent(siteId));
        model.put((Object)"acqu", (Object)acqu);
        model.put((Object)"list", list);
        return "acquisition/progress_data";
    }

    @RequestMapping(value={"/acquisition/v_progress.do"})
    public String progress(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        Integer siteId = site.getId();
        CmsAcquisition acqu = this.manager.getStarted(siteId);
        if (acqu == null) {
            this.cmsAcquisitionTempMng.clear(siteId);
        }
        return "acquisition/progress";
    }

    @RequestMapping(value={"/acquisition/v_history.do"})
    public String history(Integer acquId, Integer pageNo, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        Integer siteId = site.getId();
        Pagination pagination = this.cmsAcquisitionHistoryMng.getPage(siteId, acquId, SimplePage.cpn((Integer)pageNo), CookieUtils.getPageSize((HttpServletRequest)request));
        model.addAttribute("pagination", (Object)pagination);
        model.addAttribute("pageNo", (Object)pagination.getPageNo());
        return "acquisition/history";
    }

    @RequestMapping(value={"/acquisition/o_delete_history.do"})
    public String deleteHistory(Integer[] ids, Integer pageNo, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        CmsAcquisitionHistory[] beans;
        WebErrors errors = this.validateHistoryDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        CmsAcquisitionHistory[] cmsAcquisitionHistoryArray = beans = this.cmsAcquisitionHistoryMng.deleteByIds(ids);
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            CmsAcquisitionHistory bean = cmsAcquisitionHistoryArray[n2];
            log.info("delete CmsAcquisitionHistory id={}", (Object)bean.getId());
            this.cmsLogMng.operating(request, "cmsAcquisitionHistory.log.delete", "id=" + bean.getId() + ";name=" + bean.getTitle());
            ++n2;
        }
        return this.history(null, pageNo, request, response, model);
    }

    private WebErrors validateSave(CmsAcquisition bean, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        bean.setSite(site);
        return errors;
    }

    private WebErrors validateEdit(Integer id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        if (this.vldExist(id, site.getId(), errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateUpdate(Integer id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        if (this.vldExist(id, site.getId(), errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateDelete(Integer[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        if (errors.ifEmpty(ids, "ids")) {
            return errors;
        }
        Integer[] integerArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Integer id = integerArray[n2];
            this.vldExist(id, site.getId(), errors);
            ++n2;
        }
        return errors;
    }

    private WebErrors validateStart(Integer[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        if (errors.ifEmpty(ids, "ids")) {
            return errors;
        }
        Integer[] integerArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Integer id = integerArray[n2];
            this.vldExist(id, site.getId(), errors);
            ++n2;
        }
        return errors;
    }

    private boolean vldExist(Integer id, Integer siteId, WebErrors errors) {
        if (errors.ifNull(id, "id")) {
            return true;
        }
        CmsAcquisition entity = this.manager.findById(id);
        if (errors.ifNotExist(entity, CmsAcquisition.class, id)) {
            return true;
        }
        if (!entity.getSite().getId().equals(siteId)) {
            errors.notInSite(CmsAcquisition.class, id);
            return true;
        }
        return false;
    }

    private WebErrors validateHistoryDelete(Integer[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        if (errors.ifEmpty(ids, "ids")) {
            return errors;
        }
        Integer[] integerArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Integer id = integerArray[n2];
            this.vldHistoryExist(id, site.getId(), errors);
            ++n2;
        }
        return errors;
    }

    private boolean vldHistoryExist(Integer id, Integer siteId, WebErrors errors) {
        if (errors.ifNull(id, "id")) {
            return true;
        }
        CmsAcquisitionHistory entity = this.cmsAcquisitionHistoryMng.findById(id);
        if (errors.ifNotExist(entity, CmsAcquisitionHistory.class, id)) {
            return true;
        }
        if (!entity.getAcquisition().getSite().getId().equals(siteId)) {
            errors.notInSite(CmsAcquisitionHistory.class, id);
            return true;
        }
        return false;
    }
}

