/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.admin.assist;

import com.jeecms.cms.entity.assist.CmsAdvertising;
import com.jeecms.cms.entity.assist.CmsAdvertisingSpace;
import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.manager.assist.CmsAdvertisingMng;
import com.jeecms.cms.manager.assist.CmsAdvertisingSpaceMng;
import com.jeecms.cms.manager.main.CmsLogMng;
import com.jeecms.cms.web.CmsUtils;
import com.jeecms.cms.web.WebErrors;
import com.jeecms.common.page.Pagination;
import com.jeecms.common.page.SimplePage;
import com.jeecms.common.upload.FileRepository;
import com.jeecms.common.web.CookieUtils;
import com.jeecms.common.web.RequestUtils;
import com.jeecms.core.entity.Ftp;
import com.jeecms.core.manager.DbFileMng;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class CmsAdvertisingAct {
    private static final Logger log = LoggerFactory.getLogger(CmsAdvertisingAct.class);
    @Autowired
    private CmsAdvertisingSpaceMng cmsAdvertisingSpaceMng;
    @Autowired
    private FileRepository fileRepository;
    @Autowired
    private DbFileMng dbFileMng;
    @Autowired
    private CmsLogMng cmsLogMng;
    @Autowired
    private CmsAdvertisingMng manager;

    @RequestMapping(value={"/advertising/v_list.do"})
    public String list(Integer queryAdspaceId, Boolean queryEnabled, Integer pageNo, HttpServletRequest request, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        Pagination pagination = this.manager.getPage(site.getId(), queryAdspaceId, queryEnabled, SimplePage.cpn((Integer)pageNo), CookieUtils.getPageSize((HttpServletRequest)request));
        List<CmsAdvertisingSpace> adspaceList = this.cmsAdvertisingSpaceMng.getList(site.getId());
        model.addAttribute("pagination", (Object)pagination);
        model.addAttribute("adspaceList", adspaceList);
        model.addAttribute("pageNo", (Object)pagination.getPageNo());
        if (queryAdspaceId != null) {
            model.addAttribute("queryAdspaceId", (Object)queryAdspaceId);
        }
        if (queryEnabled != null) {
            model.addAttribute("queryEnabled", (Object)queryEnabled);
        }
        return "advertising/list";
    }

    @RequestMapping(value={"/advertising/v_add.do"})
    public String add(HttpServletRequest request, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        List<CmsAdvertisingSpace> adspaceList = this.cmsAdvertisingSpaceMng.getList(site.getId());
        model.addAttribute("adspaceList", adspaceList);
        return "advertising/add";
    }

    @RequestMapping(value={"/advertising/v_edit.do"})
    public String edit(Integer id, Integer pageNo, HttpServletRequest request, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        CmsAdvertising cmsAdvertising = this.manager.findById(id);
        model.addAttribute("cmsAdvertising", (Object)cmsAdvertising);
        model.addAttribute("attr", cmsAdvertising.getAttr());
        model.addAttribute("adspaceList", this.cmsAdvertisingSpaceMng.getList(site.getId()));
        model.addAttribute("pageNo", (Object)pageNo);
        return "advertising/edit";
    }

    @RequestMapping(value={"/advertising/o_save.do"})
    public String save(CmsAdvertising bean, Integer adspaceId, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateSave(bean, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        Map attr = RequestUtils.getRequestMap((HttpServletRequest)request, (String)"attr_");
        HashSet<String> toRemove = new HashSet<String>();
        for (Map.Entry entry : attr.entrySet()) {
            if (!StringUtils.isBlank((String)((String)entry.getValue()))) continue;
            toRemove.add((String)entry.getKey());
        }
        for (String key : toRemove) {
            attr.remove(key);
        }
        bean = this.manager.save(bean, adspaceId, attr);
        log.info("save CmsAdvertising id={}", (Object)bean.getId());
        this.cmsLogMng.operating(request, "cmsAdvertising.log.save", "id=" + bean.getId() + ";name=" + bean.getName());
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/advertising/o_update.do"})
    public String update(Integer queryAdspaceId, Boolean queryEnabled, CmsAdvertising bean, Integer adspaceId, Integer pageNo, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateUpdate(bean.getId(), request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        Map attr = RequestUtils.getRequestMap((HttpServletRequest)request, (String)"attr_");
        HashSet<String> toRemove = new HashSet<String>();
        for (Map.Entry entry : attr.entrySet()) {
            if (!StringUtils.isBlank((String)((String)entry.getValue()))) continue;
            toRemove.add((String)entry.getKey());
        }
        for (String key : toRemove) {
            attr.remove(key);
        }
        bean = this.manager.update(bean, adspaceId, attr);
        log.info("update CmsAdvertising id={}.", (Object)bean.getId());
        this.cmsLogMng.operating(request, "cmsAdvertising.log.update", "id=" + bean.getId() + ";name=" + bean.getName());
        return this.list(queryAdspaceId, queryEnabled, pageNo, request, model);
    }

    @RequestMapping(value={"/advertising/o_delete.do"})
    public String delete(Integer[] ids, Integer queryAdspaceId, Boolean queryEnabled, Integer pageNo, HttpServletRequest request, ModelMap model) {
        CmsAdvertising[] beans;
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        CmsAdvertising[] cmsAdvertisingArray = beans = this.manager.deleteByIds(ids);
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            CmsAdvertising bean = cmsAdvertisingArray[n2];
            log.info("delete CmsAdvertising id={}", (Object)bean.getId());
            this.cmsLogMng.operating(request, "cmsAdvertising.log.delete", "id=" + bean.getId() + ";name=" + bean.getName());
            ++n2;
        }
        return this.list(queryAdspaceId, queryEnabled, pageNo, request, model);
    }

    @RequestMapping(value={"/advertising/o_upload_flash.do"})
    public String uploadFlash(@RequestParam(value="flashFile", required=false) MultipartFile file, String flashNum, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateUpload(file, request);
        if (errors.hasErrors()) {
            model.addAttribute("error", errors.getErrors().get(0));
            return "advertising/flash_iframe";
        }
        CmsSite site = CmsUtils.getSite(request);
        String origName = file.getOriginalFilename();
        String ext = FilenameUtils.getExtension((String)origName).toLowerCase(Locale.ENGLISH);
        try {
            String fileUrl;
            if (site.getConfig().getUploadToDb().booleanValue()) {
                String dbFilePath = site.getConfig().getDbFileUri();
                fileUrl = this.dbFileMng.storeByExt(site.getUploadPath(), ext, file.getInputStream());
                fileUrl = String.valueOf(request.getContextPath()) + dbFilePath + fileUrl;
            } else if (site.getUploadFtp() != null) {
                Ftp ftp = site.getUploadFtp();
                String ftpUrl = ftp.getUrl();
                fileUrl = ftp.storeByExt(site.getUploadPath(), ext, file.getInputStream());
                fileUrl = String.valueOf(ftpUrl) + fileUrl;
            } else {
                String ctx = request.getContextPath();
                fileUrl = this.fileRepository.storeByExt(site.getUploadPath(), ext, file);
                fileUrl = String.valueOf(ctx) + fileUrl;
            }
            model.addAttribute("flashPath", (Object)fileUrl);
            model.addAttribute("flashName", (Object)origName);
            model.addAttribute("flashNum", (Object)flashNum);
        }
        catch (IllegalStateException e) {
            model.addAttribute("error", (Object)e.getMessage());
            log.error("upload file error!", (Throwable)e);
        }
        catch (IOException e) {
            model.addAttribute("error", (Object)e.getMessage());
            log.error("upload file error!", (Throwable)e);
        }
        return "advertising/flash_iframe";
    }

    private WebErrors validateSave(CmsAdvertising bean, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        bean.setSite(site);
        return errors;
    }

    private WebErrors validateEdit(Integer id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        if (this.vldExist(id, site.getId(), errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateUpdate(Integer id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        if (this.vldExist(id, site.getId(), errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateDelete(Integer[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        if (errors.ifEmpty(ids, "ids")) {
            return errors;
        }
        Integer[] integerArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Integer id = integerArray[n2];
            this.vldExist(id, site.getId(), errors);
            ++n2;
        }
        return errors;
    }

    private boolean vldExist(Integer id, Integer siteId, WebErrors errors) {
        if (errors.ifNull(id, "id")) {
            return true;
        }
        CmsAdvertising entity = this.manager.findById(id);
        if (errors.ifNotExist(entity, CmsAdvertising.class, id)) {
            return true;
        }
        if (!entity.getSite().getId().equals(siteId)) {
            errors.notInSite(CmsAdvertising.class, id);
            return true;
        }
        return false;
    }

    private WebErrors validateUpload(MultipartFile file, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        if (errors.ifNull(file, "file")) {
            return errors;
        }
        return errors;
    }
}

