/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.admin.assist;

import com.jeecms.cms.entity.assist.CmsAdvertisingSpace;
import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.manager.assist.CmsAdvertisingSpaceMng;
import com.jeecms.cms.manager.main.CmsLogMng;
import com.jeecms.cms.web.CmsUtils;
import com.jeecms.cms.web.WebErrors;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class CmsAdvertisingSpaceAct {
    private static final Logger log = LoggerFactory.getLogger(CmsAdvertisingSpaceAct.class);
    @Autowired
    private CmsLogMng cmsLogMng;
    @Autowired
    private CmsAdvertisingSpaceMng manager;

    @RequestMapping(value={"/advertising_space/v_list.do"})
    public String list(Integer pageNo, HttpServletRequest request, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        List<CmsAdvertisingSpace> list = this.manager.getList(site.getId());
        model.addAttribute("list", list);
        return "advertising_space/list";
    }

    @RequestMapping(value={"/advertising_space/v_add.do"})
    public String add(ModelMap model) {
        return "advertising_space/add";
    }

    @RequestMapping(value={"/advertising_space/v_edit.do"})
    public String edit(Integer id, Integer pageNo, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        model.addAttribute("cmsAdvertisingSpace", (Object)this.manager.findById(id));
        model.addAttribute("pageNo", (Object)pageNo);
        return "advertising_space/edit";
    }

    @RequestMapping(value={"/advertising_space/o_save.do"})
    public String save(CmsAdvertisingSpace bean, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateSave(bean, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.save(bean);
        log.info("save CmsAdvertisingSpace id={}", (Object)bean.getId());
        this.cmsLogMng.operating(request, "cmsAdvertisingSpace.log.save", "id=" + bean.getId() + ";name=" + bean.getName());
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/advertising_space/o_update.do"})
    public String update(CmsAdvertisingSpace bean, Integer pageNo, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateUpdate(bean.getId(), request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.update(bean);
        log.info("update CmsAdvertisingSpace id={}.", (Object)bean.getId());
        this.cmsLogMng.operating(request, "cmsAdvertisingSpace.log.update", "id=" + bean.getId() + ";name=" + bean.getName());
        return this.list(pageNo, request, model);
    }

    @RequestMapping(value={"/advertising_space/o_delete.do"})
    public String delete(Integer[] ids, Integer pageNo, HttpServletRequest request, ModelMap model) {
        CmsAdvertisingSpace[] beans;
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        CmsAdvertisingSpace[] cmsAdvertisingSpaceArray = beans = this.manager.deleteByIds(ids);
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            CmsAdvertisingSpace bean = cmsAdvertisingSpaceArray[n2];
            log.info("delete CmsAdvertisingSpace id={}", (Object)bean.getId());
            this.cmsLogMng.operating(request, "cmsAdvertisingSpace.log.delete", "id=" + bean.getId() + ";name=" + bean.getName());
            ++n2;
        }
        return this.list(pageNo, request, model);
    }

    private WebErrors validateSave(CmsAdvertisingSpace bean, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        bean.setSite(site);
        return errors;
    }

    private WebErrors validateEdit(Integer id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        if (this.vldExist(id, site.getId(), errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateUpdate(Integer id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        if (this.vldExist(id, site.getId(), errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateDelete(Integer[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        if (errors.ifEmpty(ids, "ids")) {
            return errors;
        }
        Integer[] integerArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Integer id = integerArray[n2];
            this.vldExist(id, site.getId(), errors);
            ++n2;
        }
        return errors;
    }

    private boolean vldExist(Integer id, Integer siteId, WebErrors errors) {
        if (errors.ifNull(id, "id")) {
            return true;
        }
        CmsAdvertisingSpace entity = this.manager.findById(id);
        if (errors.ifNotExist(entity, CmsAdvertisingSpace.class, id)) {
            return true;
        }
        if (!entity.getSite().getId().equals(siteId)) {
            errors.notInSite(CmsAdvertisingSpace.class, id);
            return true;
        }
        return false;
    }
}

