/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.admin.assist;

import com.jeecms.cms.entity.assist.CmsComment;
import com.jeecms.cms.entity.assist.CmsCommentExt;
import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.manager.assist.CmsCommentMng;
import com.jeecms.cms.manager.main.CmsLogMng;
import com.jeecms.cms.web.CmsUtils;
import com.jeecms.cms.web.WebErrors;
import com.jeecms.common.page.Pagination;
import com.jeecms.common.page.SimplePage;
import com.jeecms.common.web.CookieUtils;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class CmsCommentAct {
    private static final Logger log = LoggerFactory.getLogger(CmsCommentAct.class);
    @Autowired
    private CmsLogMng cmsLogMng;
    @Autowired
    private CmsCommentMng manager;

    @RequestMapping(value={"/comment/v_list.do"})
    public String list(Integer queryContentId, Boolean queryChecked, Boolean queryRecommend, Integer pageNo, HttpServletRequest request, ModelMap model) {
        if (queryRecommend == null) {
            queryRecommend = false;
        }
        CmsSite site = CmsUtils.getSite(request);
        Pagination pagination = this.manager.getPage(site.getId(), queryContentId, null, queryChecked, queryRecommend, true, SimplePage.cpn((Integer)pageNo), CookieUtils.getPageSize((HttpServletRequest)request));
        model.addAttribute("pagination", (Object)pagination);
        return "comment/list";
    }

    @RequestMapping(value={"/comment/v_add.do"})
    public String add(ModelMap model) {
        return "comment/add";
    }

    @RequestMapping(value={"/comment/v_edit.do"})
    public String edit(Integer id, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        model.addAttribute("cmsComment", (Object)this.manager.findById(id));
        return "comment/edit";
    }

    @RequestMapping(value={"/comment/o_update.do"})
    public String update(Integer queryContentId, Boolean queryChecked, Boolean queryRecommend, String reply, CmsComment bean, CmsCommentExt ext, Integer pageNo, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateUpdate(bean.getId(), request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        if (StringUtils.isNotBlank((String)ext.getReply()) && !reply.equals(ext.getReply())) {
            bean.setReplayTime(new Date());
        }
        bean = this.manager.update(bean, ext);
        log.info("update CmsComment id={}.", (Object)bean.getId());
        this.cmsLogMng.operating(request, "cmsComment.log.update", "id=" + bean.getId());
        return this.list(queryContentId, queryChecked, queryRecommend, pageNo, request, model);
    }

    @RequestMapping(value={"/comment/o_delete.do"})
    public String delete(Integer queryContentId, Boolean queryChecked, Boolean queryRecommend, Integer[] ids, Integer pageNo, HttpServletRequest request, ModelMap model) {
        CmsComment[] beans;
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        CmsComment[] cmsCommentArray = beans = this.manager.deleteByIds(ids);
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            CmsComment bean = cmsCommentArray[n2];
            log.info("delete CmsComment id={}", (Object)bean.getId());
            this.cmsLogMng.operating(request, "cmsComment.log.delete", "id=" + bean.getId());
            ++n2;
        }
        return this.list(queryContentId, queryChecked, queryRecommend, pageNo, request, model);
    }

    private WebErrors validateEdit(Integer id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        if (this.vldExist(id, site.getId(), errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateUpdate(Integer id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        if (this.vldExist(id, site.getId(), errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateDelete(Integer[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        if (errors.ifEmpty(ids, "ids")) {
            return errors;
        }
        Integer[] integerArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Integer id = integerArray[n2];
            this.vldExist(id, site.getId(), errors);
            ++n2;
        }
        return errors;
    }

    private boolean vldExist(Integer id, Integer siteId, WebErrors errors) {
        if (errors.ifNull(id, "id")) {
            return true;
        }
        CmsComment entity = this.manager.findById(id);
        if (errors.ifNotExist(entity, CmsComment.class, id)) {
            return true;
        }
        if (!entity.getSite().getId().equals(siteId)) {
            errors.notInSite(CmsComment.class, id);
            return true;
        }
        return false;
    }
}

