/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.admin.assist;

import com.jeecms.cms.entity.assist.CmsFriendlink;
import com.jeecms.cms.entity.assist.CmsFriendlinkCtg;
import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.manager.assist.CmsFriendlinkCtgMng;
import com.jeecms.cms.manager.assist.CmsFriendlinkMng;
import com.jeecms.cms.manager.main.CmsLogMng;
import com.jeecms.cms.web.CmsUtils;
import com.jeecms.cms.web.WebErrors;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class CmsFriendlinkAct {
    private static final Logger log = LoggerFactory.getLogger(CmsFriendlinkAct.class);
    @Autowired
    private CmsFriendlinkCtgMng cmsFriendlinkCtgMng;
    @Autowired
    private CmsLogMng cmsLogMng;
    @Autowired
    private CmsFriendlinkMng manager;

    @RequestMapping(value={"/friendlink/v_list.do"})
    public String list(Integer queryCtgId, HttpServletRequest request, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        List<CmsFriendlink> list = this.manager.getList(site.getId(), queryCtgId, null);
        List<CmsFriendlinkCtg> ctgList = this.cmsFriendlinkCtgMng.getList(site.getId());
        model.addAttribute("list", list);
        model.addAttribute("ctgList", ctgList);
        if (queryCtgId != null) {
            model.addAttribute("queryCtgId", (Object)queryCtgId);
        }
        return "friendlink/list";
    }

    @RequestMapping(value={"/friendlink/v_add.do"})
    public String add(ModelMap model, HttpServletRequest request) {
        CmsSite site = CmsUtils.getSite(request);
        WebErrors errors = this.validateAdd(request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        List<CmsFriendlinkCtg> ctgList = this.cmsFriendlinkCtgMng.getList(site.getId());
        model.addAttribute("ctgList", ctgList);
        return "friendlink/add";
    }

    @RequestMapping(value={"/friendlink/v_edit.do"})
    public String edit(Integer id, Integer queryCtgId, HttpServletRequest request, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        model.addAttribute("cmsFriendlink", (Object)this.manager.findById(id));
        List<CmsFriendlinkCtg> ctgList = this.cmsFriendlinkCtgMng.getList(site.getId());
        model.addAttribute("ctgList", ctgList);
        if (queryCtgId != null) {
            model.addAttribute("queryCtgId", (Object)queryCtgId);
        }
        return "friendlink/edit";
    }

    @RequestMapping(value={"/friendlink/o_save.do"})
    public String save(CmsFriendlink bean, Integer ctgId, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateSave(bean, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.save(bean, ctgId);
        log.info("save CmsFriendlink id={}", (Object)bean.getId());
        this.cmsLogMng.operating(request, "cmsFriendlink.log.save", "id=" + bean.getId() + ";name=" + bean.getName());
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/friendlink/o_update.do"})
    public String update(CmsFriendlink bean, Integer ctgId, Integer queryCtgId, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateUpdate(bean.getId(), request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.update(bean, ctgId);
        log.info("update CmsFriendlink id={}.", (Object)bean.getId());
        this.cmsLogMng.operating(request, "cmsFriendlink.log.update", "id=" + bean.getId() + ";name=" + bean.getName());
        return this.list(queryCtgId, request, model);
    }

    @RequestMapping(value={"/friendlink/o_priority.do"})
    public String priority(Integer[] wids, Integer[] priority, Integer queryCtgId, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validatePriority(wids, priority, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        this.manager.updatePriority(wids, priority);
        log.info("update CmsFriendlink priority.");
        return this.list(queryCtgId, request, model);
    }

    @RequestMapping(value={"/friendlink/o_delete.do"})
    public String delete(Integer[] ids, Integer queryCtgId, HttpServletRequest request, ModelMap model) {
        CmsFriendlink[] beans;
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        CmsFriendlink[] cmsFriendlinkArray = beans = this.manager.deleteByIds(ids);
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            CmsFriendlink bean = cmsFriendlinkArray[n2];
            log.info("delete CmsFriendlink id={}", (Object)bean.getId());
            this.cmsLogMng.operating(request, "cmsFriendlink.log.delete", "id=" + bean.getId() + ";name=" + bean.getName());
            ++n2;
        }
        return this.list(queryCtgId, request, model);
    }

    private WebErrors validateAdd(HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        if (this.cmsFriendlinkCtgMng.countBySiteId(site.getId()) <= 0) {
            errors.addErrorCode("cmsFriendlink.error.addFriendlinkCtgFirst");
            return errors;
        }
        return errors;
    }

    private WebErrors validateSave(CmsFriendlink bean, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        bean.setSite(site);
        return errors;
    }

    private WebErrors validateEdit(Integer id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        if (this.vldExist(id, site.getId(), errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateUpdate(Integer id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        if (this.vldExist(id, site.getId(), errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validatePriority(Integer[] ids, Integer[] priorities, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        return errors;
    }

    private WebErrors validateDelete(Integer[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        if (errors.ifEmpty(ids, "ids")) {
            return errors;
        }
        Integer[] integerArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Integer id = integerArray[n2];
            this.vldExist(id, site.getId(), errors);
            ++n2;
        }
        return errors;
    }

    private boolean vldExist(Integer id, Integer siteId, WebErrors errors) {
        if (errors.ifNull(id, "id")) {
            return true;
        }
        CmsFriendlink entity = this.manager.findById(id);
        if (errors.ifNotExist(entity, CmsFriendlink.class, id)) {
            return true;
        }
        if (!entity.getSite().getId().equals(siteId)) {
            errors.notInSite(CmsFriendlink.class, id);
            return true;
        }
        return false;
    }
}

