/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.admin.assist;

import com.jeecms.cms.entity.assist.CmsFriendlinkCtg;
import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.manager.assist.CmsFriendlinkCtgMng;
import com.jeecms.cms.manager.assist.CmsFriendlinkMng;
import com.jeecms.cms.manager.main.CmsLogMng;
import com.jeecms.cms.web.CmsUtils;
import com.jeecms.cms.web.WebErrors;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class CmsFriendlinkCtgAct {
    private static final Logger log = LoggerFactory.getLogger(CmsFriendlinkCtgAct.class);
    @Autowired
    private CmsFriendlinkMng cmsFriendlinkMng;
    @Autowired
    private CmsLogMng cmsLogMng;
    @Autowired
    private CmsFriendlinkCtgMng manager;

    @RequestMapping(value={"/friendlink_ctg/v_list.do"})
    public String list(HttpServletRequest request, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        List<CmsFriendlinkCtg> list = this.manager.getList(site.getId());
        model.addAttribute("list", list);
        return "friendlink_ctg/list";
    }

    @RequestMapping(value={"/friendlink_ctg/o_save.do"})
    public String save(CmsFriendlinkCtg bean, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateSave(bean, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.save(bean);
        log.info("save CmsFriendlinkCtg id={}", (Object)bean.getId());
        this.cmsLogMng.operating(request, "cmsFriendlinkCtg.log.save", "id=" + bean.getId() + ";name=" + bean.getName());
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/friendlink_ctg/o_update.do"})
    public String update(Integer[] wids, String[] name, Integer[] priority, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateUpdate(wids, name, priority, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        this.manager.updateFriendlinkCtgs(wids, name, priority);
        log.info("update CmsFriendlinkCtg.");
        this.cmsLogMng.operating(request, "cmsFriendlinkCtg.log.update", null);
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/friendlink_ctg/o_delete.do"})
    public String delete(Integer[] ids, HttpServletRequest request, ModelMap model) {
        CmsFriendlinkCtg[] beans;
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        CmsFriendlinkCtg[] cmsFriendlinkCtgArray = beans = this.manager.deleteByIds(ids);
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            CmsFriendlinkCtg bean = cmsFriendlinkCtgArray[n2];
            log.info("delete CmsFriendlinkCtg id={}", (Object)bean.getId());
            this.cmsLogMng.operating(request, "cmsFriendlinkCtg.log.delete", "id=" + bean.getId() + ";name=" + bean.getName());
            ++n2;
        }
        return "redirect:v_list.do";
    }

    private WebErrors validateSave(CmsFriendlinkCtg bean, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        bean.setSite(site);
        return errors;
    }

    private WebErrors validateUpdate(Integer[] ids, String[] names, Integer[] priorities, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        return errors;
    }

    private WebErrors validateDelete(Integer[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        if (errors.ifEmpty(ids, "ids")) {
            return errors;
        }
        Integer[] integerArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Integer id = integerArray[n2];
            this.vldExist(id, site.getId(), errors);
            if (this.cmsFriendlinkMng.countByCtgId(id) > 0) {
                String code = "cmsFriendlinkCtg.error.delFriendlinkFirst";
                errors.addErrorCode(code);
                return errors;
            }
            ++n2;
        }
        return errors;
    }

    private boolean vldExist(Integer id, Integer siteId, WebErrors errors) {
        if (errors.ifNull(id, "id")) {
            return true;
        }
        CmsFriendlinkCtg entity = this.manager.findById(id);
        if (errors.ifNotExist(entity, CmsFriendlinkCtg.class, id)) {
            return true;
        }
        if (!entity.getSite().getId().equals(siteId)) {
            errors.notInSite(CmsFriendlinkCtg.class, id);
            return true;
        }
        return false;
    }
}

