/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.admin.assist;

import com.jeecms.cms.entity.assist.CmsGuestbook;
import com.jeecms.cms.entity.assist.CmsGuestbookCtg;
import com.jeecms.cms.entity.assist.CmsGuestbookExt;
import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.manager.assist.CmsGuestbookCtgMng;
import com.jeecms.cms.manager.assist.CmsGuestbookMng;
import com.jeecms.cms.manager.main.CmsLogMng;
import com.jeecms.cms.web.CmsUtils;
import com.jeecms.cms.web.WebErrors;
import com.jeecms.common.page.Pagination;
import com.jeecms.common.page.SimplePage;
import com.jeecms.common.web.CookieUtils;
import com.jeecms.common.web.RequestUtils;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class CmsGuestbookAct {
    private static final Logger log = LoggerFactory.getLogger(CmsGuestbookAct.class);
    @Autowired
    private CmsGuestbookCtgMng cmsGuestbookCtgMng;
    @Autowired
    private CmsLogMng cmsLogMng;
    @Autowired
    private CmsGuestbookMng manager;

    @RequestMapping(value={"/guestbook/v_list.do"})
    public String list(Integer queryCtgId, Boolean queryRecommend, Boolean queryChecked, Integer pageNo, HttpServletRequest request, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        Pagination pagination = this.manager.getPage(site.getId(), queryCtgId, null, queryRecommend, queryChecked, true, false, SimplePage.cpn((Integer)pageNo), CookieUtils.getPageSize((HttpServletRequest)request));
        model.addAttribute("pagination", (Object)pagination);
        model.addAttribute("pageNo", (Object)pagination.getPageNo());
        return "guestbook/list";
    }

    @RequestMapping(value={"/guestbook/v_add.do"})
    public String add(HttpServletRequest request, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        List<CmsGuestbookCtg> ctgList = this.cmsGuestbookCtgMng.getList(site.getId());
        model.addAttribute("ctgList", ctgList);
        return "guestbook/add";
    }

    @RequestMapping(value={"/guestbook/v_edit.do"})
    public String edit(Integer id, Integer pageNo, HttpServletRequest request, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        CmsGuestbook cmsGuestbook = this.manager.findById(id);
        List<CmsGuestbookCtg> ctgList = this.cmsGuestbookCtgMng.getList(site.getId());
        model.addAttribute("cmsGuestbook", (Object)cmsGuestbook);
        model.addAttribute("ctgList", ctgList);
        model.addAttribute("pageNo", (Object)pageNo);
        return "guestbook/edit";
    }

    @RequestMapping(value={"/guestbook/o_save.do"})
    public String save(CmsGuestbook bean, CmsGuestbookExt ext, Integer ctgId, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateSave(bean, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        String ip = RequestUtils.getIpAddr((HttpServletRequest)request);
        bean = this.manager.save(bean, ext, ctgId, ip);
        log.info("save CmsGuestbook id={}", (Object)bean.getId());
        this.cmsLogMng.operating(request, "cmsGuestbook.log.save", "id=" + bean.getId() + ";title=" + bean.getTitle());
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/guestbook/o_update.do"})
    public String update(Integer queryCtgId, Boolean queryRecommend, Boolean queryChecked, String oldreply, CmsGuestbook bean, CmsGuestbookExt ext, Integer ctgId, Integer pageNo, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateUpdate(bean.getId(), request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        Date now = new Date();
        if (StringUtils.isNotBlank((String)ext.getReply()) && !oldreply.equals(ext.getReply())) {
            bean.setReplayTime(now);
            if (bean.getAdmin() != null) {
                if (!bean.getAdmin().equals(CmsUtils.getUser(request))) {
                    bean.setAdmin(CmsUtils.getUser(request));
                }
            } else {
                bean.setAdmin(CmsUtils.getUser(request));
            }
        }
        bean = this.manager.update(bean, ext, ctgId);
        log.info("update CmsGuestbook id={}.", (Object)bean.getId());
        this.cmsLogMng.operating(request, "cmsGuestbook.log.update", "id=" + bean.getId() + ";title=" + bean.getTitle());
        return this.list(queryCtgId, queryRecommend, queryChecked, pageNo, request, model);
    }

    @RequestMapping(value={"/guestbook/o_delete.do"})
    public String delete(Integer queryCtgId, Boolean queryRecommend, Boolean queryChecked, Integer[] ids, Integer pageNo, HttpServletRequest request, ModelMap model) {
        CmsGuestbook[] beans;
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        CmsGuestbook[] cmsGuestbookArray = beans = this.manager.deleteByIds(ids);
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            CmsGuestbook bean = cmsGuestbookArray[n2];
            log.info("delete CmsGuestbook id={}", (Object)bean.getId());
            this.cmsLogMng.operating(request, "cmsGuestbook.log.delete", "id=" + bean.getId() + ";title=" + bean.getTitle());
            ++n2;
        }
        return this.list(queryCtgId, queryRecommend, queryChecked, pageNo, request, model);
    }

    private WebErrors validateSave(CmsGuestbook bean, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        bean.setSite(site);
        return errors;
    }

    private WebErrors validateEdit(Integer id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        if (this.vldExist(id, site.getId(), errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateUpdate(Integer id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        if (this.vldExist(id, site.getId(), errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateDelete(Integer[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        if (errors.ifEmpty(ids, "ids")) {
            return errors;
        }
        Integer[] integerArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Integer id = integerArray[n2];
            this.vldExist(id, site.getId(), errors);
            ++n2;
        }
        return errors;
    }

    private boolean vldExist(Integer id, Integer siteId, WebErrors errors) {
        if (errors.ifNull(id, "id")) {
            return true;
        }
        CmsGuestbook entity = this.manager.findById(id);
        if (errors.ifNotExist(entity, CmsGuestbook.class, id)) {
            return true;
        }
        if (!entity.getSite().getId().equals(siteId)) {
            errors.notInSite(CmsGuestbook.class, id);
            return true;
        }
        return false;
    }
}

