/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.admin.assist;

import com.jeecms.cms.entity.assist.CmsGuestbookCtg;
import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.manager.assist.CmsGuestbookCtgMng;
import com.jeecms.cms.manager.main.CmsLogMng;
import com.jeecms.cms.web.CmsUtils;
import com.jeecms.cms.web.WebErrors;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class CmsGuestbookCtgAct {
    private static final Logger log = LoggerFactory.getLogger(CmsGuestbookCtgAct.class);
    @Autowired
    private CmsLogMng cmsLogMng;
    @Autowired
    private CmsGuestbookCtgMng manager;

    @RequestMapping(value={"/guestbook_ctg/v_list.do"})
    public String list(Integer pageNo, HttpServletRequest request, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        List<CmsGuestbookCtg> list = this.manager.getList(site.getId());
        model.addAttribute("list", list);
        return "guestbook_ctg/list";
    }

    @RequestMapping(value={"/guestbook_ctg/v_add.do"})
    public String add(ModelMap model) {
        return "guestbook_ctg/add";
    }

    @RequestMapping(value={"/guestbook_ctg/v_edit.do"})
    public String edit(Integer id, Integer pageNo, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        model.addAttribute("cmsGuestbookCtg", (Object)this.manager.findById(id));
        model.addAttribute("pageNo", (Object)pageNo);
        return "guestbook_ctg/edit";
    }

    @RequestMapping(value={"/guestbook_ctg/o_save.do"})
    public String save(CmsGuestbookCtg bean, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateSave(bean, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.save(bean);
        log.info("save CmsGuestbookCtg id={}", (Object)bean.getId());
        this.cmsLogMng.operating(request, "cmsGuestbookCtg.log.save", "id=" + bean.getId() + ";name=" + bean.getName());
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/guestbook_ctg/o_update.do"})
    public String update(CmsGuestbookCtg bean, Integer pageNo, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateUpdate(bean.getId(), request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.update(bean);
        log.info("update CmsGuestbookCtg id={}.", (Object)bean.getId());
        this.cmsLogMng.operating(request, "cmsGuestbookCtg.log.update", "id=" + bean.getId() + ";name=" + bean.getName());
        return this.list(pageNo, request, model);
    }

    @RequestMapping(value={"/guestbook_ctg/o_delete.do"})
    public String delete(Integer[] ids, Integer pageNo, HttpServletRequest request, ModelMap model) {
        CmsGuestbookCtg[] beans;
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        CmsGuestbookCtg[] cmsGuestbookCtgArray = beans = this.manager.deleteByIds(ids);
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            CmsGuestbookCtg bean = cmsGuestbookCtgArray[n2];
            log.info("delete CmsGuestbookCtg id={}", (Object)bean.getId());
            this.cmsLogMng.operating(request, "cmsGuestbookCtg.log.delete", "id=" + bean.getId() + ";name=" + bean.getName());
            ++n2;
        }
        return this.list(pageNo, request, model);
    }

    private WebErrors validateSave(CmsGuestbookCtg bean, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        bean.setSite(site);
        return errors;
    }

    private WebErrors validateEdit(Integer id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        if (this.vldExist(id, site.getId(), errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateUpdate(Integer id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        if (this.vldExist(id, site.getId(), errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateDelete(Integer[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        if (errors.ifEmpty(ids, "ids")) {
            return errors;
        }
        Integer[] integerArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Integer id = integerArray[n2];
            this.vldExist(id, site.getId(), errors);
            ++n2;
        }
        return errors;
    }

    private boolean vldExist(Integer id, Integer siteId, WebErrors errors) {
        if (errors.ifNull(id, "id")) {
            return true;
        }
        CmsGuestbookCtg entity = this.manager.findById(id);
        if (errors.ifNotExist(entity, CmsGuestbookCtg.class, id)) {
            return true;
        }
        if (!entity.getSite().getId().equals(siteId)) {
            errors.notInSite(CmsGuestbookCtg.class, id);
            return true;
        }
        return false;
    }
}

