/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.admin.assist;

import com.jeecms.cms.entity.assist.CmsKeyword;
import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.manager.assist.CmsKeywordMng;
import com.jeecms.cms.manager.main.CmsLogMng;
import com.jeecms.cms.web.CmsUtils;
import com.jeecms.cms.web.WebErrors;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class CmsKeywordAct {
    private static final Logger log = LoggerFactory.getLogger(CmsKeywordAct.class);
    @Autowired
    private CmsLogMng cmsLogMng;
    @Autowired
    private CmsKeywordMng manager;

    @RequestMapping(value={"/keyword/v_list.do"})
    public String list(HttpServletRequest request, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        List<CmsKeyword> list = this.manager.getListBySiteId(site.getId(), false, false);
        model.addAttribute("list", list);
        return "keyword/list";
    }

    @RequestMapping(value={"/keyword/o_save.do"})
    public String save(CmsKeyword bean, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateSave(bean, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.save(bean);
        model.addAttribute("message", (Object)"global.success");
        log.info("save CmsKeyword id={}", (Object)bean.getId());
        this.cmsLogMng.operating(request, "cmsKeyword.log.save", "id=" + bean.getId() + ";name=" + bean.getName());
        return this.list(request, model);
    }

    @RequestMapping(value={"/keyword/o_update.do"})
    public String update(Integer[] id, String[] name, String[] url, Boolean[] disabled, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateUpdate(id, name, url, disabled, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        if (id != null && id.length > 0) {
            this.manager.updateKeywords(id, name, url, disabled);
        }
        log.info("update CmsKeyword");
        model.addAttribute("message", (Object)"global.success");
        this.cmsLogMng.operating(request, "cmsKeyword.log.update", null);
        return this.list(request, model);
    }

    @RequestMapping(value={"/keyword/o_delete.do"})
    public String delete(Integer[] ids, HttpServletRequest request, ModelMap model) {
        CmsKeyword[] beans;
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        CmsKeyword[] cmsKeywordArray = beans = this.manager.deleteByIds(ids);
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            CmsKeyword bean = cmsKeywordArray[n2];
            log.info("delete CmsKeyword id={}", (Object)bean.getId());
            this.cmsLogMng.operating(request, "cmsKeyword.log.delete", "id=" + bean.getId() + ";name=" + bean.getName());
            ++n2;
        }
        return this.list(request, model);
    }

    private WebErrors validateSave(CmsKeyword bean, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        return errors;
    }

    private WebErrors validateUpdate(Integer[] ids, String[] names, String[] urls, Boolean[] disalbeds, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        if (errors.ifEmpty(ids, "id")) {
            return errors;
        }
        if (errors.ifEmpty(names, "name")) {
            return errors;
        }
        if (errors.ifEmpty(urls, "url")) {
            return errors;
        }
        if (ids.length != names.length || ids.length != urls.length) {
            errors.addErrorString("id, name, url length not equals");
            return errors;
        }
        Integer[] integerArray = ids;
        if (ids.length != 0) {
            Integer id = integerArray[0];
            this.vldExist(id, site.getId(), errors);
            return errors;
        }
        return errors;
    }

    private WebErrors validateDelete(Integer[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        if (errors.ifEmpty(ids, "ids")) {
            return errors;
        }
        Integer[] integerArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Integer id = integerArray[n2];
            this.vldExist(id, site.getId(), errors);
            ++n2;
        }
        return errors;
    }

    private boolean vldExist(Integer id, Integer siteId, WebErrors errors) {
        if (errors.ifNull(id, "id")) {
            return true;
        }
        CmsKeyword entity = this.manager.findById(id);
        return errors.ifNotExist(entity, CmsKeyword.class, id);
    }
}

