/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.admin.assist;

import com.jeecms.cms.entity.assist.CmsMessage;
import com.jeecms.cms.entity.assist.CmsReceiverMessage;
import com.jeecms.cms.entity.main.CmsGroup;
import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.entity.main.CmsUser;
import com.jeecms.cms.manager.assist.CmsMessageMng;
import com.jeecms.cms.manager.assist.CmsReceiverMessageMng;
import com.jeecms.cms.manager.main.CmsGroupMng;
import com.jeecms.cms.manager.main.CmsLogMng;
import com.jeecms.cms.manager.main.CmsUserMng;
import com.jeecms.cms.web.CmsUtils;
import com.jeecms.cms.web.WebErrors;
import com.jeecms.common.page.Pagination;
import com.jeecms.common.page.SimplePage;
import com.jeecms.common.web.CookieUtils;
import com.jeecms.common.web.ResponseUtils;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class CmsMessageAct {
    private static final Logger log = LoggerFactory.getLogger(CmsMessageAct.class);
    @Autowired
    private CmsLogMng cmsLogMng;
    @Autowired
    private CmsMessageMng messageMng;
    @Autowired
    private CmsReceiverMessageMng receiverMessageMng;
    @Autowired
    private CmsUserMng userMng;
    @Autowired
    private CmsGroupMng groupMng;

    @RequestMapping(value={"/message/v_list.do"})
    public String list(Integer pageNo, String title, Date sendBeginTime, Date sendEndTime, Boolean status, Integer box, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        CmsUser user = CmsUtils.getUser(request);
        Pagination pagination = null;
        String returnPage = "message/inbox";
        if (box == null) {
            box = 0;
        }
        if (box.equals(0)) {
            pagination = this.receiverMessageMng.getPage(site.getId(), null, (Integer)user.getId(), title, sendBeginTime, sendEndTime, status, box, false, SimplePage.cpn((Integer)pageNo), CookieUtils.getPageSize((HttpServletRequest)request));
            returnPage = "message/inbox";
        } else if (box.equals(1)) {
            pagination = this.messageMng.getPage(site.getId(), (Integer)user.getId(), null, title, sendBeginTime, sendEndTime, status, box, false, SimplePage.cpn((Integer)pageNo), CookieUtils.getPageSize((HttpServletRequest)request));
            returnPage = "message/sendbox";
        } else if (box.equals(2)) {
            pagination = this.messageMng.getPage(site.getId(), (Integer)user.getId(), null, title, sendBeginTime, sendEndTime, status, box, false, SimplePage.cpn((Integer)pageNo), CookieUtils.getPageSize((HttpServletRequest)request));
            returnPage = "message/draftbox";
        } else if (box.equals(3)) {
            pagination = this.receiverMessageMng.getPage(site.getId(), (Integer)user.getId(), (Integer)user.getId(), title, sendBeginTime, sendEndTime, status, box, false, SimplePage.cpn((Integer)pageNo), CookieUtils.getPageSize((HttpServletRequest)request));
            returnPage = "message/trashbox";
        }
        model.addAttribute("msg", request.getAttribute("msg"));
        model.addAttribute("pagination", (Object)pagination);
        model.addAttribute("pageNo", (Object)pageNo);
        model.addAttribute("title", (Object)title);
        model.addAttribute("sendBeginTime", (Object)sendBeginTime);
        model.addAttribute("sendEndTime", (Object)sendEndTime);
        model.addAttribute("status", (Object)status);
        model.addAttribute("box", (Object)box);
        return returnPage;
    }

    @RequestMapping(value={"/message/v_add.do"})
    public String add(ModelMap model) {
        List<CmsGroup> groups = this.groupMng.getList();
        model.addAttribute("groupList", groups);
        return "message/add";
    }

    @RequestMapping(value={"/message/v_send.do"})
    public String send(CmsMessage message, String username, Integer groupId, Integer pageNo, String title, Date sendBeginTime, Date sendEndTime, Boolean status, Integer box, ModelMap model, HttpServletRequest request, HttpServletResponse response) {
        block10: {
            CmsUser msgReceiverUser;
            Date now;
            CmsUser user;
            CmsSite site;
            block11: {
                site = CmsUtils.getSite(request);
                user = CmsUtils.getUser(request);
                now = new Date();
                CmsReceiverMessage receiverMessage = new CmsReceiverMessage();
                msgReceiverUser = this.userMng.findByUsername(username);
                if (msgReceiverUser != null) {
                    this.messageInfoSet(message, receiverMessage, user, msgReceiverUser, now, site, request);
                }
                if (groupId == null || groupId.equals(-1)) break block10;
                if (!groupId.equals(0)) break block11;
                List users = this.userMng.getList(null, null, null, null, false, false, null);
                if (users != null && users.size() > 0) {
                    int i = 0;
                    while (i < users.size()) {
                        CmsUser tempUser = (CmsUser)users.get(i);
                        CmsMessage tempMsg = new CmsMessage();
                        tempMsg.setMsgTitle(message.getMsgTitle());
                        tempMsg.setMsgContent(message.getMsgContent());
                        CmsReceiverMessage tempReceiverMsg = new CmsReceiverMessage();
                        if (msgReceiverUser != null) {
                            if (!tempUser.equals(msgReceiverUser)) {
                                this.messageInfoSet(tempMsg, tempReceiverMsg, user, tempUser, now, site, request);
                            }
                        } else {
                            this.messageInfoSet(tempMsg, tempReceiverMsg, user, tempUser, now, site, request);
                        }
                        ++i;
                    }
                }
                break block10;
            }
            List users = this.userMng.getList(null, null, null, groupId, false, false, null);
            if (users == null || users.size() <= 0) break block10;
            int i = 0;
            while (i < users.size()) {
                CmsUser tempUser = (CmsUser)users.get(i);
                CmsMessage tempMsg = new CmsMessage();
                tempMsg.setMsgTitle(message.getMsgTitle());
                tempMsg.setMsgContent(message.getMsgContent());
                CmsReceiverMessage tempReceiverMsg = new CmsReceiverMessage();
                if (msgReceiverUser != null) {
                    if (!tempUser.equals(msgReceiverUser)) {
                        this.messageInfoSet(tempMsg, tempReceiverMsg, user, tempUser, now, site, request);
                    }
                } else {
                    this.messageInfoSet(tempMsg, tempReceiverMsg, user, tempUser, now, site, request);
                }
                ++i;
            }
        }
        return this.list(pageNo, title, sendBeginTime, sendEndTime, status, 1, request, response, model);
    }

    private void messageInfoSet(CmsMessage message, CmsReceiverMessage receiverMessage, CmsUser sendUser, CmsUser receiverUser, Date sendTime, CmsSite site, HttpServletRequest request) {
        message.setMsgBox(1);
        message.setMsgSendUser(sendUser);
        message.setMsgReceiverUser(receiverUser);
        message.setMsgStatus(false);
        message.setSendTime(sendTime);
        message.setSite(site);
        this.messageMng.save(message);
        receiverMessage.setMsgBox(0);
        receiverMessage.setMsgContent(message.getMsgContent());
        receiverMessage.setMsgSendUser(sendUser);
        receiverMessage.setMsgReceiverUser(receiverUser);
        receiverMessage.setMsgStatus(false);
        receiverMessage.setMsgTitle(message.getMsgTitle());
        receiverMessage.setSendTime(sendTime);
        receiverMessage.setSite(site);
        receiverMessage.setMessage(message);
        this.receiverMessageMng.save(receiverMessage);
        log.info("member CmsMessage send CmsMessage success. id={}", (Object)message.getId());
        this.cmsLogMng.operating(request, "cmsMessage.log.send", "id=" + message.getId() + ";title=" + message.getMsgTitle());
    }

    @RequestMapping(value={"/message/v_save.do"})
    public String save(CmsMessage message, String username, Integer pageNo, String title, Date sendBeginTime, Date sendEndTime, Boolean status, Integer box, ModelMap model, HttpServletRequest request, HttpServletResponse response) {
        CmsSite site = CmsUtils.getSite(request);
        CmsUser user = CmsUtils.getUser(request);
        message.setMsgBox(2);
        message.setMsgSendUser(user);
        CmsUser msgReceiverUser = this.userMng.findByUsername(username);
        message.setMsgReceiverUser(msgReceiverUser);
        message.setMsgStatus(false);
        message.setSendTime(null);
        message.setSite(site);
        this.messageMng.save(message);
        CmsReceiverMessage receiverMessage = new CmsReceiverMessage(message);
        receiverMessage.setMsgBox(2);
        receiverMessage.setMessage(message);
        this.receiverMessageMng.save(receiverMessage);
        this.cmsLogMng.operating(request, "cmsMessage.log.save", "id=" + message.getId() + ";title=" + message.getMsgTitle());
        return this.list(pageNo, title, sendBeginTime, sendEndTime, status, 2, request, response, model);
    }

    @RequestMapping(value={"/message/v_tosend.do"})
    public String message_tosend(Integer id, Integer pageNo, String title, Date sendBeginTime, Date sendEndTime, Boolean status, Integer box, ModelMap model, HttpServletRequest request, HttpServletResponse response) {
        CmsMessage message = this.messageMng.findById(id);
        message.setMsgBox(1);
        message.setSendTime(new Date());
        this.messageMng.update(message);
        Set<CmsReceiverMessage> receiverMessageSet = message.getReceiverMsgs();
        for (CmsReceiverMessage receiverMessage : receiverMessageSet) {
            receiverMessage.setMsgBox(0);
            receiverMessage.setSendTime(new Date());
            receiverMessage.setMessage(message);
            this.receiverMessageMng.update(receiverMessage);
        }
        log.info("member CmsMessage send CmsMessage success. id={}", (Object)message.getId());
        this.cmsLogMng.operating(request, "cmsMessage.log.send", "id=" + message.getId() + ";title=" + message.getMsgTitle());
        return this.list(pageNo, title, sendBeginTime, sendEndTime, status, 1, request, response, model);
    }

    @RequestMapping(value={"/message/v_edit.do"})
    public String edit(Integer id, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        CmsMessage message = this.messageMng.findById(id);
        model.addAttribute("message", (Object)message);
        return "message/edit";
    }

    @RequestMapping(value={"/message/o_update.do"})
    public String update(CmsMessage message, Integer pageNo, String title, Date sendBeginTime, Date sendEndTime, Boolean status, Integer box, ModelMap model, HttpServletRequest request, HttpServletResponse response) {
        message = this.messageMng.update(message);
        Set<CmsReceiverMessage> receiverMessageSet = message.getReceiverMsgs();
        for (CmsReceiverMessage receiverMessage : receiverMessageSet) {
            receiverMessage.setMsgContent(message.getContentHtml());
            receiverMessage.setMsgReceiverUser(message.getMsgReceiverUser());
            receiverMessage.setMsgTitle(message.getMsgTitle());
            receiverMessage.setMessage(message);
            this.receiverMessageMng.update(receiverMessage);
        }
        log.info("member CmsMessage update CmsMessage success. id={}", (Object)message.getId());
        this.cmsLogMng.operating(request, "cmsMessage.log.update", "id=" + message.getId() + ";title=" + message.getMsgTitle());
        return this.list(pageNo, title, sendBeginTime, sendEndTime, status, box, request, response, model);
    }

    @RequestMapping(value={"/message/v_read.do"})
    public String read(Integer id, Integer box, HttpServletRequest request, ModelMap model) {
        CmsUser user = CmsUtils.getUser(request);
        CmsReceiverMessage message = this.receiverMessageMng.findById(id);
        if (message != null) {
            if (message.getMsgReceiverUser().equals(user)) {
                message.setMsgStatus(true);
                this.receiverMessageMng.update(message);
            }
            model.addAttribute("message", (Object)message);
        } else {
            CmsMessage msg = this.messageMng.findById(id);
            model.addAttribute("message", (Object)msg);
        }
        model.addAttribute("box", (Object)box);
        return "message/read";
    }

    @RequestMapping(value={"/message/v_forward.do"})
    public String forward(Integer id, HttpServletRequest request, ModelMap model) {
        CmsReceiverMessage receiverMessage = this.receiverMessageMng.findById(id);
        if (receiverMessage != null) {
            model.addAttribute("message", (Object)receiverMessage);
        } else {
            CmsMessage message = this.messageMng.findById(id);
            model.addAttribute("message", (Object)message);
        }
        List<CmsGroup> groups = this.groupMng.getList();
        model.addAttribute("groupList", groups);
        return "message/add";
    }

    @RequestMapping(value={"/message/v_reply.do"})
    public String reply(Integer id, HttpServletRequest request, ModelMap model) {
        CmsReceiverMessage receiverMessage = this.receiverMessageMng.findById(id);
        model.addAttribute("message", (Object)receiverMessage);
        List<CmsGroup> groups = this.groupMng.getList();
        model.addAttribute("groupList", groups);
        return "message/reply";
    }

    @RequestMapping(value={"/message/v_trash.do"})
    public void trash(Integer[] ids, HttpServletRequest request, HttpServletResponse response, ModelMap model) throws JSONException {
        CmsUser user = CmsUtils.getUser(request);
        JSONObject object = new JSONObject();
        if (user == null) {
            object.put("result", false);
        } else {
            Integer i = 0;
            while (i < ids.length) {
                CmsMessage message = this.messageMng.findById(ids[i]);
                CmsReceiverMessage receiverMessage = this.receiverMessageMng.findById(ids[i]);
                if (message != null && message.getMsgSendUser().equals(user)) {
                    receiverMessage = new CmsReceiverMessage();
                    receiverMessage.setMsgBox(3);
                    receiverMessage.setMsgContent(message.getMsgContent());
                    receiverMessage.setMsgSendUser(message.getMsgSendUser());
                    receiverMessage.setMsgReceiverUser(user);
                    receiverMessage.setMsgStatus(message.getMsgStatus());
                    receiverMessage.setMsgTitle(message.getMsgTitle());
                    receiverMessage.setSendTime(message.getSendTime());
                    receiverMessage.setSite(message.getSite());
                    receiverMessage.setMessage(null);
                    this.receiverMessageMng.save(receiverMessage);
                    Set<CmsReceiverMessage> receiverMessages = message.getReceiverMsgs();
                    if (receiverMessages != null && receiverMessages.size() > 0) {
                        for (CmsReceiverMessage tempReceiverMessage : receiverMessages) {
                            tempReceiverMessage.setMessage(null);
                            this.receiverMessageMng.update(tempReceiverMessage);
                        }
                    }
                    this.messageMng.deleteById(ids[i]);
                    this.cmsLogMng.operating(request, "cmsMessage.log.trash", "id=" + message.getId() + ";title=" + message.getMsgTitle());
                }
                if (receiverMessage != null && receiverMessage.getMsgReceiverUser().equals(user)) {
                    receiverMessage.setMsgBox(3);
                    this.receiverMessageMng.update(receiverMessage);
                    this.cmsLogMng.operating(request, "cmsMessage.log.trash", "id=" + receiverMessage.getId() + ";title=" + receiverMessage.getMsgTitle());
                }
                log.info("member CmsMessage trash CmsMessage success. id={}", (Object)ids[i]);
                i = i + 1;
            }
            object.put("result", true);
        }
        ResponseUtils.renderJson((HttpServletResponse)response, (String)object.toString());
    }

    @RequestMapping(value={"/message/v_revert.do"})
    public void revert(Integer[] ids, HttpServletRequest request, HttpServletResponse response, ModelMap model) throws JSONException {
        CmsUser user = CmsUtils.getUser(request);
        JSONObject object = new JSONObject();
        if (user == null) {
            object.put("result", false);
        } else {
            Integer i = 0;
            while (i < ids.length) {
                CmsReceiverMessage receiverMessage = this.receiverMessageMng.findById(ids[i]);
                if (receiverMessage != null && receiverMessage.getMsgReceiverUser().equals(user)) {
                    receiverMessage.setMsgBox(0);
                    this.receiverMessageMng.update(receiverMessage);
                    this.cmsLogMng.operating(request, "cmsMessage.log.revert", "id=" + receiverMessage.getId() + ";title=" + receiverMessage.getMsgTitle());
                }
                log.info("member CmsMessage revert CmsMessage success. id={}", (Object)ids[i]);
                i = i + 1;
            }
            object.put("result", true);
        }
        ResponseUtils.renderJson((HttpServletResponse)response, (String)object.toString());
    }

    @RequestMapping(value={"/message/v_empty.do"})
    public void empty(Integer[] ids, HttpServletRequest request, HttpServletResponse response, ModelMap model) throws JSONException {
        CmsUser user = CmsUtils.getUser(request);
        JSONObject object = new JSONObject();
        CmsMessage message = null;
        if (user == null) {
            object.put("result", false);
        } else {
            Integer i = 0;
            while (i < ids.length) {
                CmsReceiverMessage receiverMessage = this.receiverMessageMng.findById(ids[i]);
                if (receiverMessage != null && receiverMessage.getMsgReceiverUser().equals(user)) {
                    this.receiverMessageMng.deleteById(ids[i]);
                } else {
                    message = receiverMessage.getMessage();
                    if (receiverMessage.getMsgBox().equals(3)) {
                        receiverMessage.setMessage(null);
                        if (message != null) {
                            this.messageMng.deleteById(message.getId());
                        }
                    } else {
                        receiverMessage.setMessage(null);
                    }
                    if (message != null && message.getMsgSendUser().equals(user)) {
                        this.messageMng.deleteById(message.getId());
                    }
                    this.cmsLogMng.operating(request, "cmsMessage.log.empty", "id=" + message.getId() + ";title=" + message.getMsgTitle());
                }
                log.info("member CmsMessage empty CmsMessage success. id={}", (Object)ids[i]);
                i = i + 1;
            }
            object.put("result", true);
        }
        ResponseUtils.renderJson((HttpServletResponse)response, (String)object.toString());
    }

    @RequestMapping(value={"/message/v_findUser.do"})
    public void findUserByUserName(String username, HttpServletRequest request, HttpServletResponse response, ModelMap model) throws JSONException {
        CmsUser user = CmsUtils.getUser(request);
        JSONObject object = new JSONObject();
        if (user == null) {
            object.put("result", false);
        } else {
            Boolean exist = this.userMng.usernameNotExist(username);
            object.put("result", true);
            object.put("exist", (Object)exist);
        }
        ResponseUtils.renderJson((HttpServletResponse)response, (String)object.toString());
    }

    @RequestMapping(value={"/message/v_countUnreadMsg.do"})
    public void findUnreadMessagesByUser(HttpServletRequest request, HttpServletResponse response, ModelMap model) throws JSONException {
        CmsUser user = CmsUtils.getUser(request);
        CmsSite site = CmsUtils.getSite(request);
        JSONObject object = new JSONObject();
        if (user == null) {
            object.put("result", false);
        } else {
            List receiverMessages = this.receiverMessageMng.getList(site.getId(), null, (Integer)user.getId(), null, null, null, false, 0, false);
            object.put("result", true);
            if (receiverMessages != null && receiverMessages.size() > 0) {
                object.put("count", receiverMessages.size());
            } else {
                object.put("count", 0);
            }
            object.put("result", true);
        }
        ResponseUtils.renderJson((HttpServletResponse)response, (String)object.toString());
    }

    private WebErrors validateEdit(Integer id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        if (this.vldExist(id, site.getId(), errors)) {
            return errors;
        }
        return errors;
    }

    private boolean vldExist(Integer id, Integer siteId, WebErrors errors) {
        if (errors.ifNull(id, "id")) {
            return true;
        }
        CmsMessage entity = this.messageMng.findById(id);
        if (errors.ifNotExist(entity, CmsMessage.class, id)) {
            return true;
        }
        if (!entity.getSite().getId().equals(siteId)) {
            errors.notInSite(CmsMessage.class, id);
            return true;
        }
        return false;
    }
}

