/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.admin.assist;

import com.jeecms.cms.entity.assist.CmsSensitivity;
import com.jeecms.cms.manager.assist.CmsSensitivityMng;
import com.jeecms.cms.manager.main.CmsLogMng;
import com.jeecms.cms.web.WebErrors;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class CmsSensitivityAct {
    private static final Logger log = LoggerFactory.getLogger(CmsSensitivityAct.class);
    @Autowired
    private CmsLogMng cmsLogMng;
    @Autowired
    private CmsSensitivityMng manager;

    @RequestMapping(value={"/sensitivity/v_list.do"})
    public String list(HttpServletRequest request, ModelMap model) {
        List<CmsSensitivity> list = this.manager.getList(false);
        model.addAttribute("list", list);
        return "sensitivity/list";
    }

    @RequestMapping(value={"/sensitivity/o_save.do"})
    public String save(CmsSensitivity bean, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateSave(bean, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.save(bean);
        model.addAttribute("message", (Object)"global.success");
        log.info("save CmsSensitivity id={}", (Object)bean.getId());
        this.cmsLogMng.operating(request, "cmsSensitivity.log.save", "id=" + bean.getId() + ";name=" + bean.getSearch());
        return this.list(request, model);
    }

    @RequestMapping(value={"/sensitivity/o_update.do"})
    public String update(Integer[] id, String[] search, String[] replacement, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateUpdate(id, search, replacement, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        this.manager.updateEnsitivity(id, search, replacement);
        model.addAttribute("message", (Object)"global.success");
        log.info("update CmsSensitivity.");
        this.cmsLogMng.operating(request, "cmsSensitivity.log.save", null);
        return this.list(request, model);
    }

    @RequestMapping(value={"/sensitivity/o_delete.do"})
    public String delete(Integer[] ids, HttpServletRequest request, ModelMap model) {
        CmsSensitivity[] beans;
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        CmsSensitivity[] cmsSensitivityArray = beans = this.manager.deleteByIds(ids);
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            CmsSensitivity bean = cmsSensitivityArray[n2];
            log.info("delete CmsSensitivity id={}", (Object)bean.getId());
            this.cmsLogMng.operating(request, "cmsSensitivity.log.delete", "id=" + bean.getId() + ";name=" + bean.getSearch());
            ++n2;
        }
        model.addAttribute("message", (Object)"global.success");
        return this.list(request, model);
    }

    private WebErrors validateSave(CmsSensitivity bean, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        return errors;
    }

    private WebErrors validateUpdate(Integer[] ids, String[] searchs, String[] replacements, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        if (errors.ifEmpty(ids, "id")) {
            return errors;
        }
        if (errors.ifEmpty(searchs, "name")) {
            return errors;
        }
        if (errors.ifEmpty(replacements, "url")) {
            return errors;
        }
        if (ids.length != searchs.length || ids.length != replacements.length) {
            errors.addErrorString("id, searchs, replacements length not equals");
            return errors;
        }
        Integer[] integerArray = ids;
        if (ids.length != 0) {
            Integer id = integerArray[0];
            this.vldExist(id, errors);
            return errors;
        }
        return errors;
    }

    private WebErrors validateDelete(Integer[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        if (errors.ifEmpty(ids, "ids")) {
            return errors;
        }
        Integer[] integerArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Integer id = integerArray[n2];
            this.vldExist(id, errors);
            ++n2;
        }
        return errors;
    }

    private boolean vldExist(Integer id, WebErrors errors) {
        if (errors.ifNull(id, "id")) {
            return true;
        }
        CmsSensitivity entity = this.manager.findById(id);
        return errors.ifNotExist(entity, CmsSensitivity.class, id);
    }
}

