/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.admin.assist;

import com.jeecms.cms.entity.assist.CmsVoteItem;
import com.jeecms.cms.entity.assist.CmsVoteTopic;
import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.manager.assist.CmsVoteTopicMng;
import com.jeecms.cms.manager.main.CmsLogMng;
import com.jeecms.cms.web.CmsUtils;
import com.jeecms.cms.web.WebErrors;
import com.jeecms.common.page.Pagination;
import com.jeecms.common.page.SimplePage;
import com.jeecms.common.web.CookieUtils;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Controller
public class CmsVoteTopicAct {
    private static final Logger log = LoggerFactory.getLogger(CmsVoteTopicAct.class);
    @Autowired
    private CmsLogMng cmsLogMng;
    @Autowired
    private CmsVoteTopicMng manager;

    @RequestMapping(value={"/vote_topic/v_list.do"})
    public String list(Integer pageNo, HttpServletRequest request, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        Pagination pagination = this.manager.getPage(site.getId(), SimplePage.cpn((Integer)pageNo), CookieUtils.getPageSize((HttpServletRequest)request));
        model.addAttribute("pagination", (Object)pagination);
        model.addAttribute("pageNo", (Object)pagination.getPageNo());
        return "vote_topic/list";
    }

    @RequestMapping(value={"/vote_topic/v_add.do"})
    public String add(ModelMap model) {
        return "vote_topic/add";
    }

    @RequestMapping(value={"/vote_topic/v_edit.do"})
    public String edit(Integer id, Integer pageNo, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        model.addAttribute("cmsVoteTopic", (Object)this.manager.findById(id));
        model.addAttribute("pageNo", (Object)pageNo);
        return "vote_topic/edit";
    }

    @RequestMapping(value={"/vote_topic/o_save.do"})
    public String save(CmsVoteTopic bean, String[] itemTitle, Integer[] itemVoteCount, Integer[] itemPriority, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateSave(bean, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        List<CmsVoteItem> items = this.getItems(null, itemTitle, itemVoteCount, itemPriority);
        bean = this.manager.save(bean, items);
        log.info("save CmsVoteTopic id={}", (Object)bean.getId());
        this.cmsLogMng.operating(request, "cmsVoteTopic.log.save", "id=" + bean.getId() + ";title=" + bean.getTitle());
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/vote_topic/o_update.do"})
    public String update(CmsVoteTopic bean, Integer[] itemId, String[] itemTitle, Integer[] itemVoteCount, Integer[] itemPriority, Integer pageNo, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateUpdate(bean.getId(), request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        List<CmsVoteItem> items = this.getItems(itemId, itemTitle, itemVoteCount, itemPriority);
        bean = this.manager.update(bean, items);
        log.info("update CmsVoteTopic id={}.", (Object)bean.getId());
        this.cmsLogMng.operating(request, "cmsVoteTopic.log.update", "id=" + bean.getId() + ";title=" + bean.getTitle());
        return this.list(pageNo, request, model);
    }

    @RequestMapping(value={"/vote_topic/o_delete.do"})
    public String delete(Integer[] ids, Integer pageNo, HttpServletRequest request, ModelMap model) {
        CmsVoteTopic[] beans;
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        CmsVoteTopic[] cmsVoteTopicArray = beans = this.manager.deleteByIds(ids);
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            CmsVoteTopic bean = cmsVoteTopicArray[n2];
            log.info("delete CmsVoteTopic id={}", (Object)bean.getId());
            this.cmsLogMng.operating(request, "cmsVoteTopic.log.delete", "id=" + bean.getId() + ";title=" + bean.getTitle());
            ++n2;
        }
        return this.list(pageNo, request, model);
    }

    private List<CmsVoteItem> getItems(Integer[] itemId, String[] itemTitle, Integer[] itemVoteCount, Integer[] itemPriority) {
        ArrayList<CmsVoteItem> items = new ArrayList<CmsVoteItem>();
        int i = 0;
        int len = itemTitle.length;
        while (i < len) {
            if (!StringUtils.isBlank((String)itemTitle[i])) {
                CmsVoteItem item = new CmsVoteItem();
                if (itemId != null && itemId[i] != null) {
                    item.setId(itemId[i]);
                }
                item.setTitle(itemTitle[i]);
                item.setVoteCount(itemVoteCount[i]);
                item.setPriority(itemPriority[i]);
                items.add(item);
            }
            ++i;
        }
        return items;
    }

    private WebErrors validateSave(CmsVoteTopic bean, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        bean.setSite(site);
        return errors;
    }

    private WebErrors validateEdit(Integer id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        if (this.vldExist(id, site.getId(), errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateUpdate(Integer id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        if (this.vldExist(id, site.getId(), errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateDelete(Integer[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        if (errors.ifEmpty(ids, "ids")) {
            return errors;
        }
        Integer[] integerArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Integer id = integerArray[n2];
            this.vldExist(id, site.getId(), errors);
            ++n2;
        }
        return errors;
    }

    private boolean vldExist(Integer id, Integer siteId, WebErrors errors) {
        if (errors.ifNull(id, "id")) {
            return true;
        }
        CmsVoteTopic entity = this.manager.findById(id);
        if (errors.ifNotExist(entity, CmsVoteTopic.class, id)) {
            return true;
        }
        if (!entity.getSite().getId().equals(siteId)) {
            errors.notInSite(CmsVoteTopic.class, id);
            return true;
        }
        return false;
    }
}

