/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.admin.assist;

import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.manager.assist.CmsResourceMng;
import com.jeecms.cms.manager.main.CmsLogMng;
import com.jeecms.cms.web.CmsUtils;
import com.jeecms.cms.web.WebErrors;
import com.jeecms.common.file.FileWrap;
import com.jeecms.common.web.RequestUtils;
import com.jeecms.common.web.ResponseUtils;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class ResourceAct {
    private static final Logger log = LoggerFactory.getLogger(ResourceAct.class);
    @Autowired
    private CmsLogMng cmsLogMng;
    private CmsResourceMng resourceMng;

    @RequestMapping(value={"/resource/v_left.do"})
    public String left(String path, HttpServletRequest request, ModelMap model) {
        return "resource/left";
    }

    @RequestMapping(value={"/resource/v_tree.do"})
    public String tree(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        String root = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"root");
        log.debug("tree path={}", (Object)root);
        if (StringUtils.isBlank((String)root) || "source".equals(root)) {
            root = site.getResPath();
            model.addAttribute("isRoot", (Object)true);
        } else {
            model.addAttribute("isRoot", (Object)false);
        }
        WebErrors errors = this.validateTree(root, request);
        if (errors.hasErrors()) {
            log.error((String)errors.getErrors().get(0));
            ResponseUtils.renderJson((HttpServletResponse)response, (String)"[]");
            return null;
        }
        List<FileWrap> resList = this.resourceMng.listFile(root, true);
        model.addAttribute("resList", resList);
        response.setHeader("Cache-Control", "no-cache");
        response.setContentType("text/json;charset=UTF-8");
        return "resource/tree";
    }

    @RequestMapping(value={"/resource/v_list.do"})
    public String list(HttpServletRequest request, ModelMap model) {
        String rel;
        CmsSite site = CmsUtils.getSite(request);
        String root = (String)model.get((Object)"root");
        if (root == null) {
            root = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"root");
        }
        log.debug("list Resource root: {}", (Object)root);
        if (StringUtils.isBlank((String)root)) {
            root = site.getResPath();
        }
        if ((rel = root.substring(site.getResPath().length())).length() == 0) {
            rel = "/";
        }
        model.addAttribute("root", (Object)root);
        model.addAttribute("rel", (Object)rel);
        model.addAttribute("list", this.resourceMng.listFile(root, false));
        return "resource/list";
    }

    @RequestMapping(value={"/resource/o_create_dir.do"})
    public String createDir(String root, String dirName, HttpServletRequest request, ModelMap model) {
        this.resourceMng.createDir(root, dirName);
        model.addAttribute("root", (Object)root);
        return this.list(request, model);
    }

    @RequestMapping(value={"/resource/v_add.do"})
    public String add(HttpServletRequest request, ModelMap model) {
        String root = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"root");
        model.addAttribute("root", (Object)root);
        return "resource/add";
    }

    @RequestMapping(value={"/resource/v_edit.do"})
    public String edit(HttpServletRequest request, ModelMap model) throws IOException {
        String root = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"root");
        String name = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"name");
        WebErrors errors = this.validateEdit(root, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        model.addAttribute("source", (Object)this.resourceMng.readFile(name));
        model.addAttribute("root", (Object)root);
        model.addAttribute("name", (Object)name);
        model.addAttribute("filename", (Object)name.substring(name.lastIndexOf(47) + 1));
        return "resource/edit";
    }

    @RequestMapping(value={"/resource/o_save.do"})
    public String save(String root, String filename, String source, HttpServletRequest request, ModelMap model) throws IOException {
        WebErrors errors = this.validateSave(filename, source, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        this.resourceMng.createFile(root, filename, source);
        model.addAttribute("root", (Object)root);
        log.info("save Resource name={}", (Object)filename);
        this.cmsLogMng.operating(request, "resource.log.save", "filename=" + filename);
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/resource/o_update.do"})
    public void update(String root, String name, String source, HttpServletRequest request, HttpServletResponse response, ModelMap model) throws IOException {
        WebErrors errors = this.validateUpdate(root, name, source, request);
        if (errors.hasErrors()) {
            ResponseUtils.renderJson((HttpServletResponse)response, (String)("{success:false,msg:'" + (String)errors.getErrors().get(0) + "'}"));
        }
        this.resourceMng.updateFile(name, source);
        log.info("update Resource name={}.", (Object)name);
        this.cmsLogMng.operating(request, "resource.log.update", "filename=" + name);
        model.addAttribute("root", (Object)root);
        ResponseUtils.renderJson((HttpServletResponse)response, (String)"{success:true}");
    }

    @RequestMapping(value={"/resource/o_delete.do"})
    public String delete(String root, String[] names, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateDelete(root, names, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        int count = this.resourceMng.delete(names);
        log.info("delete Resource count: {}", (Object)count);
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            log.info("delete Resource name={}", (Object)name);
            this.cmsLogMng.operating(request, "resource.log.delete", "filename=" + name);
            ++n2;
        }
        model.addAttribute("root", (Object)root);
        return this.list(request, model);
    }

    @RequestMapping(value={"/resource/o_delete_single.do"})
    public String deleteSingle(HttpServletRequest request, ModelMap model) {
        String root = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"root");
        String name = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"name");
        int count = this.resourceMng.delete(new String[]{name});
        log.info("delete Resource {}, count {}", (Object)name, (Object)count);
        this.cmsLogMng.operating(request, "resource.log.delete", "filename=" + name);
        model.addAttribute("root", (Object)root);
        return this.list(request, model);
    }

    @RequestMapping(value={"/resource/v_rename.do"})
    public String renameInput(HttpServletRequest request, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        String root = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"root");
        String name = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"name");
        String origName = name.substring(site.getResPath().length());
        model.addAttribute("origName", (Object)origName);
        model.addAttribute("root", (Object)root);
        return "resource/rename";
    }

    @RequestMapping(value={"/resource/o_rename.do"}, method={RequestMethod.POST})
    public String renameSubmit(String root, String origName, String distName, HttpServletRequest request, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        String orig = String.valueOf(site.getResPath()) + origName;
        String dist = String.valueOf(site.getResPath()) + distName;
        this.resourceMng.rename(orig, dist);
        log.info("name Resource from {} to {}", (Object)orig, (Object)dist);
        model.addAttribute("root", (Object)root);
        return this.list(request, model);
    }

    @RequestMapping(value={"/resource/v_upload.do"})
    public String uploadInput(HttpServletRequest request, ModelMap model) {
        String root = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"root");
        model.addAttribute("root", (Object)root);
        return "resource/upload";
    }

    @RequestMapping(value={"/resource/o_upload.do"}, method={RequestMethod.POST})
    public String uploadSubmit(String root, HttpServletRequest request, ModelMap model) {
        model.addAttribute("root", (Object)root);
        return this.list(request, model);
    }

    @RequestMapping(value={"/resource/o_swfupload.do"}, method={RequestMethod.POST})
    public void swfUpload(String root, @RequestParam(value="Filedata", required=false) MultipartFile file, HttpServletRequest request, HttpServletResponse response, ModelMap model) throws IllegalStateException, IOException {
        this.resourceMng.saveFile(root, file);
        model.addAttribute("root", (Object)root);
        log.info("file upload seccess: {}, size:{}.", (Object)file.getOriginalFilename(), (Object)file.getSize());
        ResponseUtils.renderText((HttpServletResponse)response, (String)"");
    }

    private WebErrors validateTree(String path, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        return errors;
    }

    private WebErrors validateSave(String name, String source, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        return errors;
    }

    private WebErrors validateEdit(String id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        if (this.vldExist(id, errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateUpdate(String root, String name, String source, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        if (this.vldExist(name, errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateDelete(String root, String[] names, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        errors.ifEmpty(names, "names");
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            this.vldExist(id, errors);
            ++n2;
        }
        return errors;
    }

    private boolean vldExist(String name, WebErrors errors) {
        return errors.ifNull(name, "name");
    }

    @Autowired
    public void setResourceMng(CmsResourceMng resourceMng) {
        this.resourceMng = resourceMng;
    }
}

