/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.admin.assist;

import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.manager.assist.CmsResourceMng;
import com.jeecms.cms.manager.main.CmsLogMng;
import com.jeecms.cms.manager.main.CmsSiteMng;
import com.jeecms.cms.web.CmsUtils;
import com.jeecms.cms.web.WebErrors;
import com.jeecms.common.util.Zipper;
import com.jeecms.common.web.RequestUtils;
import com.jeecms.common.web.ResponseUtils;
import com.jeecms.core.tpl.Tpl;
import com.jeecms.core.tpl.TplManager;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class TemplateAct {
    private static final Logger log = LoggerFactory.getLogger(TemplateAct.class);
    @Autowired
    private CmsLogMng cmsLogMng;
    private TplManager tplManager;
    private CmsResourceMng resourceMng;
    private CmsSiteMng cmsSiteMng;

    @RequestMapping(value={"/template/v_left.do"})
    public String left(String path, HttpServletRequest request, ModelMap model) {
        return "template/left";
    }

    @RequestMapping(value={"/template/v_tree.do"}, method={RequestMethod.GET})
    public String tree(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        String root = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"root");
        log.debug("tree path={}", (Object)root);
        if (StringUtils.isBlank((String)root) || "source".equals(root)) {
            root = site.getTplPath();
            model.addAttribute("isRoot", (Object)true);
        } else {
            model.addAttribute("isRoot", (Object)false);
        }
        WebErrors errors = this.validateTree(root, request);
        if (errors.hasErrors()) {
            log.error((String)errors.getErrors().get(0));
            ResponseUtils.renderJson((HttpServletResponse)response, (String)"[]");
            return null;
        }
        List tplList = this.tplManager.getChild(root);
        model.addAttribute("tplList", (Object)tplList);
        response.setHeader("Cache-Control", "no-cache");
        response.setContentType("text/json;charset=UTF-8");
        return "template/tree";
    }

    @RequestMapping(value={"/template/v_list.do"}, method={RequestMethod.GET})
    public String list(HttpServletRequest request, ModelMap model) {
        String rel;
        CmsSite site = CmsUtils.getSite(request);
        String root = (String)model.get((Object)"root");
        if (root == null) {
            root = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"root");
        }
        log.debug("list Template root: {}", (Object)root);
        if (StringUtils.isBlank((String)root)) {
            root = site.getTplPath();
        }
        if ((rel = root.substring(site.getTplPath().length())).length() == 0) {
            rel = "/";
        }
        model.addAttribute("root", (Object)root);
        model.addAttribute("rel", (Object)rel);
        model.addAttribute("list", (Object)this.tplManager.getChild(root));
        return "template/list";
    }

    @RequestMapping(value={"/template/o_create_dir.do"})
    public String createDir(String root, String dirName, HttpServletRequest request, ModelMap model) {
        this.tplManager.save(String.valueOf(root) + "/" + dirName, null, true);
        model.addAttribute("root", (Object)root);
        return this.list(request, model);
    }

    @RequestMapping(value={"/template/v_add.do"}, method={RequestMethod.GET})
    public String add(HttpServletRequest request, ModelMap model) {
        String root = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"root");
        model.addAttribute("root", (Object)root);
        return "template/add";
    }

    @RequestMapping(value={"/template/v_edit.do"})
    public String edit(HttpServletRequest request, ModelMap model) {
        String root = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"root");
        String name = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"name");
        WebErrors errors = this.validateEdit(root, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        model.addAttribute("template", (Object)this.tplManager.get(name));
        model.addAttribute("root", (Object)root);
        return "template/edit";
    }

    @RequestMapping(value={"/template/o_save.do"})
    public String save(String root, String filename, String source, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateSave(filename, source, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        String name = String.valueOf(root) + "/" + filename + ".html";
        this.tplManager.save(name, source, false);
        model.addAttribute("root", (Object)root);
        log.info("save Template name={}", (Object)filename);
        this.cmsLogMng.operating(request, "template.log.save", "filename=" + filename);
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/template/o_update.do"})
    public String update(String root, String name, String source, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        WebErrors errors = this.validateUpdate(root, name, source, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        source = source.replaceAll("&quot;", "\"");
        source = source.replaceAll("&amp;", "&");
        this.tplManager.update(name, source);
        log.info("update Template name={}.", (Object)name);
        this.cmsLogMng.operating(request, "template.log.update", "filename=" + name);
        model.addAttribute("template", (Object)this.tplManager.get(name));
        model.addAttribute("root", (Object)root);
        return "template/edit";
    }

    @RequestMapping(value={"/template/o_delete.do"})
    public String delete(String root, String[] names, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateDelete(root, names, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        int count = this.tplManager.delete(names);
        log.info("delete Template count: {}", (Object)count);
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            log.info("delete Template name={}", (Object)name);
            this.cmsLogMng.operating(request, "template.log.delete", "filename=" + name);
            ++n2;
        }
        model.addAttribute("root", (Object)root);
        return this.list(request, model);
    }

    @RequestMapping(value={"/template/o_delete_single.do"})
    public String deleteSingle(HttpServletRequest request, ModelMap model) {
        String root = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"root");
        String name = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"name");
        int count = this.tplManager.delete(new String[]{name});
        log.info("delete Template {}, count {}", (Object)name, (Object)count);
        this.cmsLogMng.operating(request, "template.log.delete", "filename=" + name);
        model.addAttribute("root", (Object)root);
        return this.list(request, model);
    }

    @RequestMapping(value={"/template/v_rename.do"}, method={RequestMethod.GET})
    public String renameInput(HttpServletRequest request, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        String root = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"root");
        String name = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"name");
        String origName = name.substring(site.getTplPath().length());
        model.addAttribute("origName", (Object)origName);
        model.addAttribute("root", (Object)root);
        return "template/rename";
    }

    @RequestMapping(value={"/template/o_rename.do"}, method={RequestMethod.POST})
    public String renameSubmit(String root, String origName, String distName, HttpServletRequest request, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        String orig = String.valueOf(site.getTplPath()) + origName;
        String dist = String.valueOf(site.getTplPath()) + distName;
        this.tplManager.rename(orig, dist);
        log.info("name Template from {} to {}", (Object)orig, (Object)dist);
        model.addAttribute("root", (Object)root);
        return this.list(request, model);
    }

    @RequestMapping(value={"/template/o_swfupload.do"}, method={RequestMethod.POST})
    public void swfUpload(String root, @RequestParam(value="Filedata", required=false) MultipartFile file, HttpServletRequest request, HttpServletResponse response, ModelMap model) throws IllegalStateException, IOException {
        this.tplManager.save(root, file);
        model.addAttribute("root", (Object)root);
        log.info("file upload seccess: {}, size:{}.", (Object)file.getOriginalFilename(), (Object)file.getSize());
        ResponseUtils.renderText((HttpServletResponse)response, (String)"");
    }

    @RequestMapping(value={"/template/v_setting.do"})
    public String setting(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        String[] solutions = this.resourceMng.getSolutions(site.getTplPath());
        model.addAttribute("solutions", (Object)solutions);
        model.addAttribute("defSolution", (Object)site.getTplSolution());
        return "template/setting";
    }

    @RequestMapping(value={"/template/o_def_template.do"})
    public void defTempate(String solution, HttpServletRequest request, HttpServletResponse response) {
        CmsSite site = CmsUtils.getSite(request);
        this.cmsSiteMng.updateTplSolution(site.getId(), solution);
        ResponseUtils.renderJson((HttpServletResponse)response, (String)"{'success':true}");
    }

    @RequestMapping(value={"/template/o_export.do"})
    public void exportSubmit(HttpServletRequest request, HttpServletResponse response) throws UnsupportedEncodingException {
        String solution = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"solution");
        CmsSite site = CmsUtils.getSite(request);
        List<Zipper.FileEntry> fileEntrys = this.resourceMng.export(site, solution);
        response.setContentType("application/x-download;charset=UTF-8");
        response.addHeader("Content-disposition", "filename=template-" + solution + ".zip");
        try {
            Zipper.zip((OutputStream)response.getOutputStream(), fileEntrys, (String)"GBK");
        }
        catch (IOException e) {
            log.error("export template error!", (Throwable)e);
        }
    }

    @RequestMapping(value={"/template/o_import.do"})
    public String importSubmit(@RequestParam(value="tplZip", required=false) MultipartFile file, HttpServletRequest request, HttpServletResponse response, ModelMap model) throws IOException {
        CmsSite site = CmsUtils.getSite(request);
        File tempFile = File.createTempFile("tplZip", "temp");
        file.transferTo(tempFile);
        this.resourceMng.imoport(tempFile, site);
        tempFile.delete();
        return this.setting(request, response, model);
    }

    private WebErrors validateTree(String path, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        return errors;
    }

    private WebErrors validateSave(String name, String source, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        return errors;
    }

    private WebErrors validateEdit(String id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        if (this.vldExist(id, errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateUpdate(String root, String name, String source, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        if (this.vldExist(name, errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateDelete(String root, String[] names, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        errors.ifEmpty(names, "names");
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            this.vldExist(id, errors);
            ++n2;
        }
        return errors;
    }

    private boolean vldExist(String name, WebErrors errors) {
        if (errors.ifNull(name, "name")) {
            return true;
        }
        Tpl entity = this.tplManager.get(name);
        return errors.ifNotExist(entity, Tpl.class, (Serializable)((Object)name));
    }

    public void setTplManager(TplManager tplManager) {
        this.tplManager = tplManager;
    }

    @Autowired
    public void setResourceMng(CmsResourceMng resourceMng) {
        this.resourceMng = resourceMng;
    }

    @Autowired
    public void setCmsSiteMng(CmsSiteMng cmsSiteMng) {
        this.cmsSiteMng = cmsSiteMng;
    }
}

