/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.admin.main;

import com.jeecms.cms.entity.main.Channel;
import com.jeecms.cms.entity.main.ChannelExt;
import com.jeecms.cms.entity.main.ChannelTxt;
import com.jeecms.cms.entity.main.CmsGroup;
import com.jeecms.cms.entity.main.CmsModel;
import com.jeecms.cms.entity.main.CmsModelItem;
import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.entity.main.CmsUser;
import com.jeecms.cms.manager.main.ChannelMng;
import com.jeecms.cms.manager.main.CmsGroupMng;
import com.jeecms.cms.manager.main.CmsLogMng;
import com.jeecms.cms.manager.main.CmsModelItemMng;
import com.jeecms.cms.manager.main.CmsModelMng;
import com.jeecms.cms.manager.main.CmsUserMng;
import com.jeecms.cms.web.CmsUtils;
import com.jeecms.cms.web.WebErrors;
import com.jeecms.common.web.RequestUtils;
import com.jeecms.common.web.ResponseUtils;
import com.jeecms.core.tpl.TplManager;
import com.jeecms.core.web.CoreUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Controller
public class ChannelAct {
    private static final Logger log = LoggerFactory.getLogger(ChannelAct.class);
    @Autowired
    private CmsUserMng cmsUserMng;
    @Autowired
    private CmsModelMng cmsModelMng;
    @Autowired
    private CmsModelItemMng cmsModelItemMng;
    @Autowired
    private CmsGroupMng cmsGroupMng;
    @Autowired
    private TplManager tplManager;
    @Autowired
    private CmsLogMng cmsLogMng;
    @Autowired
    private ChannelMng manager;

    @RequestMapping(value={"/channel/v_left.do"})
    public String left() {
        return "channel/left";
    }

    @RequestMapping(value={"/channel/v_tree.do"})
    public String tree(String root, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        List<Channel> list;
        log.debug("tree path={}", (Object)root);
        boolean isRoot = StringUtils.isBlank((String)root) || "source".equals(root);
        model.addAttribute("isRoot", (Object)isRoot);
        WebErrors errors = this.validateTree(root, request);
        if (errors.hasErrors()) {
            log.error((String)errors.getErrors().get(0));
            ResponseUtils.renderJson((HttpServletResponse)response, (String)"[]");
            return null;
        }
        if (isRoot) {
            CmsSite site = CmsUtils.getSite(request);
            list = this.manager.getTopList(site.getId(), false);
        } else {
            Integer rootId = Integer.valueOf(root);
            list = this.manager.getChildList(rootId, false);
        }
        model.addAttribute("list", list);
        response.setHeader("Cache-Control", "no-cache");
        response.setContentType("text/json;charset=UTF-8");
        return "channel/tree";
    }

    @RequestMapping(value={"/channel/v_list.do"})
    public String list(Integer root, HttpServletRequest request, ModelMap model) {
        List<Channel> list = root == null ? this.manager.getTopList(CmsUtils.getSiteId(request), false) : this.manager.getChildList(root, false);
        model.addAttribute("modelList", this.cmsModelMng.getList(false));
        model.addAttribute("root", (Object)root);
        model.addAttribute("list", list);
        return "channel/list";
    }

    @RequestMapping(value={"/channel/v_add.do"})
    public String add(Integer root, Integer modelId, HttpServletRequest request, ModelMap model) {
        List<CmsGroup> groupList;
        CmsSite site = CmsUtils.getSite(request);
        Channel parent = null;
        if (root != null) {
            parent = this.manager.findById(root);
            model.addAttribute("parent", (Object)parent);
            model.addAttribute("root", (Object)root);
        }
        CmsModel m = this.cmsModelMng.findById(modelId);
        List<String> channelTplList = this.getTplChannel(site, m, null);
        List<String> contentTplList = this.getTplContent(site, m, null);
        List<CmsModelItem> itemList = this.cmsModelItemMng.getList(modelId, true, false);
        List<CmsGroup> viewGroups = groupList = this.cmsGroupMng.getList();
        Collection<CmsGroup> contriGroups = parent != null ? parent.getContriGroups() : groupList;
        Collection<CmsUser> users = parent != null ? parent.getUsers() : this.cmsUserMng.getAdminList(site.getId(), false, false, null);
        model.addAttribute("channelTplList", channelTplList);
        model.addAttribute("contentTplList", contentTplList);
        model.addAttribute("itemList", itemList);
        model.addAttribute("viewGroups", viewGroups);
        model.addAttribute("contriGroups", contriGroups);
        model.addAttribute("contriGroupIds", (Object)CmsGroup.fetchIds(contriGroups));
        model.addAttribute("users", users);
        model.addAttribute("userIds", (Object)CmsUser.fetchIds(users));
        model.addAttribute("model", (Object)m);
        return "channel/add";
    }

    @RequestMapping(value={"/channel/v_edit.do"})
    public String edit(Integer id, Integer root, HttpServletRequest request, ModelMap model) {
        String tplContent;
        CmsSite site = CmsUtils.getSite(request);
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        if (root != null) {
            model.addAttribute("root", (Object)root);
        }
        Channel channel = this.manager.findById(id);
        int tplPathLength = site.getTplPath().length();
        String tplChannel = channel.getTplChannel();
        if (!StringUtils.isBlank((String)tplChannel)) {
            tplChannel = tplChannel.substring(tplPathLength);
        }
        if (!StringUtils.isBlank((String)(tplContent = channel.getTplContent()))) {
            tplContent = tplContent.substring(tplPathLength);
        }
        Channel parent = channel.getParent();
        CmsModel m = channel.getModel();
        List<Channel> topList = this.manager.getTopList(site.getId(), false);
        List<Channel> channelList = Channel.getListForSelect(topList, null, channel, false);
        List<String> channelTplList = this.getTplChannel(site, m, channel.getTplChannel());
        List<String> contentTplList = this.getTplContent(site, m, channel.getTplContent());
        List<CmsGroup> groupList = this.cmsGroupMng.getList();
        List<CmsModelItem> itemList = this.cmsModelItemMng.getList(m.getId(), true, false);
        List<CmsGroup> viewGroups = groupList;
        Integer[] viewGroupIds = CmsGroup.fetchIds(channel.getViewGroups());
        Collection<CmsGroup> contriGroups = parent != null ? parent.getContriGroups() : groupList;
        Integer[] contriGroupIds = CmsGroup.fetchIds(channel.getContriGroups());
        Collection<CmsUser> users = parent != null ? parent.getUsers() : this.cmsUserMng.getAdminList(site.getId(), false, false, null);
        Integer[] userIds = channel.getUserIds();
        model.addAttribute("channelList", channelList);
        model.addAttribute("modelList", this.cmsModelMng.getList(false));
        model.addAttribute("tplChannel", (Object)tplChannel);
        model.addAttribute("tplContent", (Object)tplContent);
        model.addAttribute("channelTplList", channelTplList);
        model.addAttribute("contentTplList", contentTplList);
        model.addAttribute("itemList", itemList);
        model.addAttribute("viewGroups", viewGroups);
        model.addAttribute("viewGroupIds", (Object)viewGroupIds);
        model.addAttribute("contriGroups", contriGroups);
        model.addAttribute("contriGroupIds", (Object)contriGroupIds);
        model.addAttribute("users", users);
        model.addAttribute("userIds", (Object)userIds);
        model.addAttribute("channel", (Object)channel);
        model.addAttribute("model", (Object)m);
        return "channel/edit";
    }

    @RequestMapping(value={"/channel/o_save.do"})
    public String save(Integer root, Channel bean, ChannelExt ext, ChannelTxt txt, Integer[] viewGroupIds, Integer[] contriGroupIds, Integer[] userIds, Integer modelId, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateSave(bean, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        CmsSite site = CmsUtils.getSite(request);
        String tplPath = site.getTplPath();
        if (!StringUtils.isBlank((String)ext.getTplChannel())) {
            ext.setTplChannel(String.valueOf(tplPath) + ext.getTplChannel());
        }
        if (!StringUtils.isBlank((String)ext.getTplContent())) {
            ext.setTplContent(String.valueOf(tplPath) + ext.getTplContent());
        }
        bean.setAttr(RequestUtils.getRequestMap((HttpServletRequest)request, (String)"attr_"));
        bean = this.manager.save(bean, ext, txt, viewGroupIds, contriGroupIds, userIds, CmsUtils.getSiteId(request), root, modelId);
        log.info("save Channel id={}, name={}", (Object)bean.getId(), (Object)bean.getName());
        this.cmsLogMng.operating(request, "channel.log.save", "id=" + bean.getId() + ";title=" + bean.getTitle());
        model.addAttribute("root", (Object)root);
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/channel/o_update.do"})
    public String update(Integer root, Channel bean, ChannelExt ext, ChannelTxt txt, Integer[] viewGroupIds, Integer[] contriGroupIds, Integer[] userIds, Integer parentId, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateUpdate((Integer)bean.getId(), request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        CmsSite site = CmsUtils.getSite(request);
        String tplPath = site.getTplPath();
        if (!StringUtils.isBlank((String)ext.getTplChannel())) {
            ext.setTplChannel(String.valueOf(tplPath) + ext.getTplChannel());
        }
        if (!StringUtils.isBlank((String)ext.getTplContent())) {
            ext.setTplContent(String.valueOf(tplPath) + ext.getTplContent());
        }
        Map attr = RequestUtils.getRequestMap((HttpServletRequest)request, (String)"attr_");
        bean = this.manager.update(bean, ext, txt, viewGroupIds, contriGroupIds, userIds, parentId, attr);
        log.info("update Channel id={}.", (Object)bean.getId());
        this.cmsLogMng.operating(request, "channel.log.update", "id=" + bean.getId() + ";name=" + bean.getName());
        return this.list(root, request, model);
    }

    @RequestMapping(value={"/channel/o_delete.do"})
    public String delete(Integer root, Integer[] ids, HttpServletRequest request, ModelMap model) {
        Channel[] beans;
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        Channel[] channelArray = beans = this.manager.deleteByIds(ids);
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            Channel bean = channelArray[n2];
            log.info("delete Channel id={}", (Object)bean.getId());
            this.cmsLogMng.operating(request, "channel.log.delete", "id=" + bean.getId() + ";title=" + bean.getTitle());
            ++n2;
        }
        return this.list(root, request, model);
    }

    @RequestMapping(value={"/channel/o_priority.do"})
    public String priority(Integer root, Integer[] wids, Integer[] priority, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validatePriority(wids, priority, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        this.manager.updatePriority(wids, priority);
        model.addAttribute("message", (Object)"global.success");
        return this.list(root, request, model);
    }

    private List<String> getTplChannel(CmsSite site, CmsModel model, String tpl) {
        String sol = site.getSolutionPath();
        List tplList = this.tplManager.getNameListByPrefix(model.getTplChannel(sol, false));
        return CoreUtils.tplTrim((List)tplList, (String)site.getTplPath(), (String)tpl, (String[])new String[0]);
    }

    private List<String> getTplContent(CmsSite site, CmsModel model, String tpl) {
        String sol = site.getSolutionPath();
        List tplList = this.tplManager.getNameListByPrefix(model.getTplContent(sol, false));
        return CoreUtils.tplTrim((List)tplList, (String)site.getTplPath(), (String)tpl, (String[])new String[0]);
    }

    private WebErrors validateTree(String path, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        return errors;
    }

    private WebErrors validateSave(Channel bean, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        bean.setSite(site);
        return errors;
    }

    private WebErrors validateEdit(Integer id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        if (this.vldExist(id, site.getId(), errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateUpdate(Integer id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        if (this.vldExist(id, site.getId(), errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateDelete(Integer[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        errors.ifEmpty(ids, "ids");
        Integer[] integerArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Integer id = integerArray[n2];
            if (this.vldExist(id, site.getId(), errors)) {
                return errors;
            }
            String code = this.manager.checkDelete(id);
            if (code != null) {
                errors.addErrorCode(code);
                return errors;
            }
            ++n2;
        }
        return errors;
    }

    private boolean vldExist(Integer id, Integer siteId, WebErrors errors) {
        if (errors.ifNull(id, "id")) {
            return true;
        }
        Channel entity = this.manager.findById(id);
        if (errors.ifNotExist(entity, Channel.class, id)) {
            return true;
        }
        if (!entity.getSite().getId().equals(siteId)) {
            errors.notInSite(Channel.class, id);
            return true;
        }
        return false;
    }

    private WebErrors validatePriority(Integer[] wids, Integer[] priority, HttpServletRequest request) {
        CmsSite site = CmsUtils.getSite(request);
        WebErrors errors = WebErrors.create(request);
        if (errors.ifEmpty(wids, "wids")) {
            return errors;
        }
        if (errors.ifEmpty(priority, "priority")) {
            return errors;
        }
        if (wids.length != priority.length) {
            errors.addErrorString("wids length not equals priority length");
            return errors;
        }
        int i = 0;
        int len = wids.length;
        while (i < len) {
            if (this.vldExist(wids[i], site.getId(), errors)) {
                return errors;
            }
            if (priority[i] == null) {
                priority[i] = 0;
            }
            ++i;
        }
        return errors;
    }
}

