/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.admin.main;

import com.jeecms.cms.action.admin.main.CmsAdminAbstract;
import com.jeecms.cms.entity.main.CmsGroup;
import com.jeecms.cms.entity.main.CmsRole;
import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.entity.main.CmsUser;
import com.jeecms.cms.entity.main.CmsUserExt;
import com.jeecms.cms.entity.main.CmsUserSite;
import com.jeecms.cms.web.CmsUtils;
import com.jeecms.cms.web.WebErrors;
import com.jeecms.common.page.Pagination;
import com.jeecms.common.page.SimplePage;
import com.jeecms.common.web.CookieUtils;
import com.jeecms.common.web.RequestUtils;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class CmsAdminLocalAct
extends CmsAdminAbstract {
    private static final Logger log = LoggerFactory.getLogger(CmsAdminLocalAct.class);

    @RequestMapping(value={"/admin_local/v_list.do"})
    public String list(String queryUsername, String queryEmail, Integer queryGroupId, Boolean queryDisabled, Integer pageNo, HttpServletRequest request, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        CmsUser currUser = CmsUtils.getUser(request);
        Pagination pagination = this.manager.getPage(queryUsername, queryEmail, site.getId(), queryGroupId, queryDisabled, true, currUser.getRank(), SimplePage.cpn((Integer)pageNo), CookieUtils.getPageSize((HttpServletRequest)request));
        model.addAttribute("pagination", (Object)pagination);
        model.addAttribute("queryUsername", (Object)queryUsername);
        model.addAttribute("queryEmail", (Object)queryEmail);
        model.addAttribute("queryGroupId", (Object)queryGroupId);
        model.addAttribute("queryDisabled", (Object)queryDisabled);
        return "admin/local/list";
    }

    @RequestMapping(value={"/admin_local/v_add.do"})
    public String add(HttpServletRequest request, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        CmsUser currUser = CmsUtils.getUser(request);
        List<CmsGroup> groupList = this.cmsGroupMng.getList();
        List<CmsRole> roleList = this.cmsRoleMng.getList();
        model.addAttribute("site", (Object)site);
        model.addAttribute("groupList", groupList);
        model.addAttribute("roleList", roleList);
        model.addAttribute("currRank", (Object)currUser.getRank());
        return "admin/local/add";
    }

    @RequestMapping(value={"/admin_local/v_edit.do"})
    public String edit(Integer id, Integer queryGroupId, Boolean queryDisabled, HttpServletRequest request, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        String queryUsername = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"queryUsername");
        String queryEmail = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"queryEmail");
        CmsUser currUser = CmsUtils.getUser(request);
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        CmsUser admin = this.manager.findById(id);
        CmsUserSite userSite = admin.getUserSite(site.getId());
        List<CmsGroup> groupList = this.cmsGroupMng.getList();
        List<CmsRole> roleList = this.cmsRoleMng.getList();
        model.addAttribute("cmsAdmin", (Object)admin);
        model.addAttribute("site", (Object)site);
        model.addAttribute("userSite", (Object)userSite);
        model.addAttribute("roleIds", (Object)admin.getRoleIds());
        model.addAttribute("groupList", groupList);
        model.addAttribute("roleList", roleList);
        model.addAttribute("currRank", (Object)currUser.getRank());
        model.addAttribute("queryUsername", (Object)queryUsername);
        model.addAttribute("queryEmail", (Object)queryEmail);
        model.addAttribute("queryGroupId", (Object)queryGroupId);
        model.addAttribute("queryDisabled", (Object)queryDisabled);
        return "admin/local/edit";
    }

    @RequestMapping(value={"/admin_local/o_save.do"})
    public String save(CmsUser bean, CmsUserExt ext, String username, String email, String password, Boolean viewonlyAdmin, Boolean selfAdmin, Integer rank, Integer groupId, Integer[] roleIds, Integer[] channelIds, Byte[] steps, Boolean[] allChannels, HttpServletRequest request, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        WebErrors errors = this.validateSave(bean, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        Integer[] siteIds = new Integer[]{site.getId()};
        String ip = RequestUtils.getIpAddr((HttpServletRequest)request);
        bean = this.manager.saveAdmin(username, email, password, ip, viewonlyAdmin, selfAdmin, rank, groupId, roleIds, channelIds, siteIds, steps, allChannels, ext);
        log.info("save CmsAdmin id={}", (Object)bean.getId());
        this.cmsLogMng.operating(request, "cmsUser.log.save", "id=" + bean.getId() + ";username=" + bean.getUsername());
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/admin_local/o_update.do"})
    public String update(CmsUser bean, CmsUserExt ext, String password, Integer groupId, Integer[] roleIds, Integer[] channelIds, Byte step, Boolean allChannel, String queryUsername, String queryEmail, Integer queryGroupId, Boolean queryDisabled, Integer pageNo, HttpServletRequest request, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        WebErrors errors = this.validateUpdate((Integer)bean.getId(), request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.updateAdmin(bean, ext, password, groupId, roleIds, channelIds, site.getId(), step, allChannel);
        log.info("update CmsAdmin id={}.", (Object)bean.getId());
        this.cmsLogMng.operating(request, "cmsUser.log.update", "id=" + bean.getId() + ";username=" + bean.getUsername());
        return this.list(queryUsername, queryEmail, queryGroupId, queryDisabled, pageNo, request, model);
    }

    @RequestMapping(value={"/admin_local/o_delete.do"})
    public String delete(Integer[] ids, Integer queryGroupId, Boolean queryDisabled, Integer pageNo, HttpServletRequest request, ModelMap model) {
        CmsUser[] beans;
        String queryUsername = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"queryUsername");
        String queryEmail = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"queryEmail");
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        CmsUser[] cmsUserArray = beans = this.manager.deleteByIds(ids);
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            CmsUser bean = cmsUserArray[n2];
            log.info("delete CmsAdmin id={}", (Object)bean.getId());
            this.cmsLogMng.operating(request, "cmsUser.log.delete", "id=" + bean.getId() + ";username=" + bean.getUsername());
            ++n2;
        }
        return this.list(queryUsername, queryEmail, queryGroupId, queryDisabled, pageNo, request, model);
    }

    @RequestMapping(value={"/admin_local/v_channels_add.do"})
    public String channelsAdd(Integer siteId, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        return this.channelsAddJson(siteId, request, response, model);
    }

    @RequestMapping(value={"/admin_local/v_channels_edit.do"})
    public String channelsEdit(Integer userId, Integer siteId, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        return this.channelsEditJson(userId, siteId, request, response, model);
    }

    @RequestMapping(value={"/admin_local/v_check_username.do"})
    public void checkUsername(String username, HttpServletResponse response) {
        this.checkUserJson(username, response);
    }

    @RequestMapping(value={"/admin_local/v_check_email.do"})
    public void checkEmail(String email, HttpServletResponse response) {
        this.checkEmailJson(email, response);
    }

    private WebErrors validateSave(CmsUser bean, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        return errors;
    }

    private WebErrors validateEdit(Integer id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        if (this.vldExist(id, errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateUpdate(Integer id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        if (this.vldExist(id, errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateDelete(Integer[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        errors.ifEmpty(ids, "ids");
        Integer[] integerArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Integer id = integerArray[n2];
            this.vldExist(id, errors);
            ++n2;
        }
        return errors;
    }

    private boolean vldExist(Integer id, WebErrors errors) {
        if (errors.ifNull(id, "id")) {
            return true;
        }
        CmsUser entity = this.manager.findById(id);
        return errors.ifNotExist(entity, CmsUser.class, id);
    }
}

