/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.admin.main;

import com.jeecms.cms.entity.main.CmsConfig;
import com.jeecms.cms.entity.main.MarkConfig;
import com.jeecms.cms.entity.main.MemberConfig;
import com.jeecms.cms.manager.main.CmsConfigMng;
import com.jeecms.cms.manager.main.CmsLogMng;
import com.jeecms.cms.web.WebErrors;
import com.jeecms.core.entity.Config;
import com.jeecms.core.manager.ConfigMng;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class CmsConfigAct {
    private static final Logger log = LoggerFactory.getLogger(CmsConfigAct.class);
    @Autowired
    private ConfigMng configMng;
    @Autowired
    private CmsLogMng cmsLogMng;
    @Autowired
    private CmsConfigMng manager;

    @RequestMapping(value={"/config/v_system_edit.do"})
    public String systemEdit(HttpServletRequest request, ModelMap model) {
        model.addAttribute("cmsConfig", (Object)this.manager.get());
        return "config/system_edit";
    }

    @RequestMapping(value={"/config/o_system_update.do"})
    public String systemUpdate(CmsConfig bean, Integer pageNo, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateSystemUpdate(bean, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.update(bean);
        model.addAttribute("message", (Object)"global.success");
        log.info("update systemConfig of CmsConfig.");
        this.cmsLogMng.operating(request, "cmsConfig.log.systemUpdate", null);
        return this.systemEdit(request, model);
    }

    @RequestMapping(value={"/config/v_mark_edit.do"})
    public String markEdit(HttpServletRequest request, ModelMap model) {
        model.addAttribute("markConfig", (Object)this.manager.get().getMarkConfig());
        return "config/mark_edit";
    }

    @RequestMapping(value={"/config/o_mark_update.do"})
    public String markUpdate(MarkConfig bean, Integer pageNo, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateMarkUpdate(bean, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.updateMarkConfig(bean);
        model.addAttribute("message", (Object)"global.success");
        log.info("update markConfig of CmsConfig.");
        this.cmsLogMng.operating(request, "cmsConfig.log.markUpdate", null);
        return this.markEdit(request, model);
    }

    @RequestMapping(value={"/config/v_member_edit.do"})
    public String memberEdit(HttpServletRequest request, ModelMap model) {
        model.addAttribute("memberConfig", (Object)this.manager.get().getMemberConfig());
        return "config/member_edit";
    }

    @RequestMapping(value={"/config/o_member_update.do"})
    public String memberUpdate(MemberConfig bean, Config.ConfigLogin configLogin, Config.ConfigEmailSender emailSender, Config.ConfigMessageTemplate msgTpl, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateMemberUpdate(bean, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        this.manager.updateMemberConfig(bean);
        model.addAttribute("message", (Object)"global.success");
        log.info("update memberConfig of CmsConfig.");
        this.cmsLogMng.operating(request, "cmsConfig.log.memberUpdate", null);
        return this.memberEdit(request, model);
    }

    @RequestMapping(value={"/config/v_login_edit.do"})
    public String loginEdit(HttpServletRequest request, ModelMap model) {
        model.addAttribute("configLogin", (Object)this.configMng.getConfigLogin());
        model.addAttribute("emailSender", (Object)this.configMng.getEmailSender());
        model.addAttribute("forgotPasswordTemplate", (Object)this.configMng.getForgotPasswordMessageTemplate());
        model.addAttribute("registerTemplate", (Object)this.configMng.getRegisterMessageTemplate());
        return "config/login_edit";
    }

    @RequestMapping(value={"/config/o_login_update.do"})
    public String loginUpdate(Config.ConfigLogin configLogin, Config.ConfigEmailSender emailSender, Config.ConfigMessageTemplate msgTpl, HttpServletRequest request, ModelMap model) {
        this.configMng.updateOrSave(configLogin.getAttr());
        this.configMng.updateOrSave(emailSender.getAttr());
        this.configMng.updateOrSave(msgTpl.getAttr());
        model.addAttribute("message", (Object)"global.success");
        log.info("update loginCoinfig of Config.");
        this.cmsLogMng.operating(request, "cmsConfig.log.loginUpdate", null);
        return this.loginEdit(request, model);
    }

    private WebErrors validateSystemUpdate(CmsConfig bean, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        return errors;
    }

    private WebErrors validateMarkUpdate(MarkConfig bean, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        return errors;
    }

    private WebErrors validateMemberUpdate(MemberConfig bean, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        return errors;
    }
}

