/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.admin.main;

import com.jeecms.cms.entity.main.CmsGroup;
import com.jeecms.cms.manager.main.CmsGroupMng;
import com.jeecms.cms.manager.main.CmsLogMng;
import com.jeecms.cms.web.WebErrors;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class CmsGroupAct {
    private static final Logger log = LoggerFactory.getLogger(CmsGroupAct.class);
    @Autowired
    private CmsLogMng cmsLogMng;
    @Autowired
    private CmsGroupMng manager;

    @RequestMapping(value={"/group/v_list.do"})
    public String list(HttpServletRequest request, ModelMap model) {
        List<CmsGroup> list = this.manager.getList();
        model.addAttribute("list", list);
        return "group/list";
    }

    @RequestMapping(value={"/group/v_add.do"})
    public String add(ModelMap model) {
        return "group/add";
    }

    @RequestMapping(value={"/group/v_edit.do"})
    public String edit(Integer id, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        model.addAttribute("cmsGroup", (Object)this.manager.findById(id));
        return "group/edit";
    }

    @RequestMapping(value={"/group/o_save.do"})
    public String save(CmsGroup bean, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateSave(bean, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.save(bean);
        log.info("save CmsGroup id={}", (Object)bean.getId());
        this.cmsLogMng.operating(request, "cmsGroup.log.save", "id=" + bean.getId() + ";name=" + bean.getName());
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/group/o_update.do"})
    public String update(CmsGroup bean, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateUpdate((Integer)bean.getId(), request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.update(bean);
        log.info("update CmsGroup id={}.", (Object)bean.getId());
        this.cmsLogMng.operating(request, "cmsGroup.log.update", "id=" + bean.getId() + ";name=" + bean.getName());
        return this.list(request, model);
    }

    @RequestMapping(value={"/group/o_delete.do"})
    public String delete(Integer[] ids, HttpServletRequest request, ModelMap model) {
        CmsGroup[] beans;
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        CmsGroup[] cmsGroupArray = beans = this.manager.deleteByIds(ids);
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            CmsGroup bean = cmsGroupArray[n2];
            log.info("delete CmsGroup id={}", (Object)bean.getId());
            this.cmsLogMng.operating(request, "cmsGroup.log.delete", "id=" + bean.getId() + ";name=" + bean.getName());
            ++n2;
        }
        return this.list(request, model);
    }

    @RequestMapping(value={"/group/o_priority.do"})
    public String priority(Integer[] wids, Integer[] priority, Integer regDefId, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validatePriority(wids, priority, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        this.manager.updatePriority(wids, priority);
        this.manager.updateRegDef(regDefId);
        model.addAttribute("message", (Object)"global.success");
        return this.list(request, model);
    }

    private WebErrors validateSave(CmsGroup bean, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        return errors;
    }

    private WebErrors validateEdit(Integer id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        if (this.vldExist(id, errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateUpdate(Integer id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        if (this.vldExist(id, errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateDelete(Integer[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        if (errors.ifEmpty(ids, "ids")) {
            return errors;
        }
        Integer[] integerArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Integer id = integerArray[n2];
            this.vldExist(id, errors);
            ++n2;
        }
        return errors;
    }

    private WebErrors validatePriority(Integer[] wids, Integer[] priority, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        if (errors.ifEmpty(wids, "wids")) {
            return errors;
        }
        if (errors.ifEmpty(priority, "priority")) {
            return errors;
        }
        if (wids.length != priority.length) {
            errors.addErrorString("wids length not equals priority length");
            return errors;
        }
        int i = 0;
        int len = wids.length;
        while (i < len) {
            if (this.vldExist(wids[i], errors)) {
                return errors;
            }
            if (priority[i] == null) {
                priority[i] = 0;
            }
            ++i;
        }
        return errors;
    }

    private boolean vldExist(Integer id, WebErrors errors) {
        if (errors.ifNull(id, "id")) {
            return true;
        }
        CmsGroup entity = this.manager.findById(id);
        return errors.ifNotExist(entity, CmsGroup.class, id);
    }
}

