/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.admin.main;

import com.jeecms.cms.entity.main.CmsLog;
import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.manager.main.CmsLogMng;
import com.jeecms.cms.web.CmsUtils;
import com.jeecms.cms.web.WebErrors;
import com.jeecms.common.page.Pagination;
import com.jeecms.common.page.SimplePage;
import com.jeecms.common.web.CookieUtils;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class CmsLogAct {
    private static final Logger log = LoggerFactory.getLogger(CmsLogAct.class);
    @Autowired
    private CmsLogMng manager;

    @RequestMapping(value={"/log/v_list_operating.do"})
    public String listOperating(String queryUsername, String queryTitle, String queryIp, Integer pageNo, HttpServletRequest request, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        Pagination pagination = this.manager.getPage(3, site.getId(), queryUsername, queryTitle, queryIp, SimplePage.cpn((Integer)pageNo), CookieUtils.getPageSize((HttpServletRequest)request));
        model.addAttribute("pagination", (Object)pagination);
        model.addAttribute("pageNo", (Object)pagination.getPageNo());
        model.addAttribute("queryUsername", (Object)queryUsername);
        model.addAttribute("queryTitle", (Object)queryTitle);
        model.addAttribute("queryIp", (Object)queryIp);
        return "log/list_operating";
    }

    @RequestMapping(value={"/log/v_list_login_success.do"})
    public String listLoginSuccess(String queryUsername, String queryTitle, String queryIp, Integer pageNo, HttpServletRequest request, ModelMap model) {
        Pagination pagination = this.manager.getPage(1, null, queryUsername, queryTitle, queryIp, SimplePage.cpn((Integer)pageNo), CookieUtils.getPageSize((HttpServletRequest)request));
        model.addAttribute("pagination", (Object)pagination);
        model.addAttribute("pageNo", (Object)pagination.getPageNo());
        model.addAttribute("queryUsername", (Object)queryUsername);
        model.addAttribute("queryTitle", (Object)queryTitle);
        model.addAttribute("queryIp", (Object)queryIp);
        return "log/list_login_success";
    }

    @RequestMapping(value={"/log/v_list_login_failure.do"})
    public String listLoginFailure(String queryTitle, String queryIp, Integer pageNo, HttpServletRequest request, ModelMap model) {
        Pagination pagination = this.manager.getPage(2, null, null, queryTitle, queryIp, SimplePage.cpn((Integer)pageNo), CookieUtils.getPageSize((HttpServletRequest)request));
        model.addAttribute("pagination", (Object)pagination);
        model.addAttribute("pageNo", (Object)pagination.getPageNo());
        model.addAttribute("queryTitle", (Object)queryTitle);
        model.addAttribute("queryIp", (Object)queryIp);
        return "log/list_login_failure";
    }

    @RequestMapping(value={"/log/o_delete_operating.do"})
    public String deleteOperating(String queryUsername, String queryTitle, String queryIp, Integer[] ids, Integer pageNo, HttpServletRequest request, ModelMap model) {
        CmsLog[] beans;
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        CmsLog[] cmsLogArray = beans = this.manager.deleteByIds(ids);
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            CmsLog bean = cmsLogArray[n2];
            log.info("delete CmsLog id={}", (Object)bean.getId());
            ++n2;
        }
        return this.listOperating(queryUsername, queryTitle, queryIp, pageNo, request, model);
    }

    @RequestMapping(value={"/log/o_delete_operating_batch.do"})
    public String deleteOperatingBatch(Integer days, HttpServletRequest request, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        this.manager.deleteBatch(3, site.getId(), days);
        model.addAttribute("message", (Object)"global.success");
        return this.listOperating(null, null, null, 1, request, model);
    }

    @RequestMapping(value={"/log/o_delete_login_success.do"})
    public String deleteLoginSuccess(String queryUsername, String queryTitle, String queryIp, Integer[] ids, Integer pageNo, HttpServletRequest request, ModelMap model) {
        CmsLog[] beans;
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        CmsLog[] cmsLogArray = beans = this.manager.deleteByIds(ids);
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            CmsLog bean = cmsLogArray[n2];
            log.info("delete CmsLog id={}", (Object)bean.getId());
            ++n2;
        }
        return this.listLoginSuccess(queryUsername, queryTitle, queryIp, pageNo, request, model);
    }

    @RequestMapping(value={"/log/o_delete_login_success_batch.do"})
    public String deleteLoginSuccessBatch(Integer days, HttpServletRequest request, ModelMap model) {
        if (days == null) {
            days = 0;
        }
        this.manager.deleteBatch(1, null, days);
        model.addAttribute("message", (Object)"global.success");
        return this.listLoginSuccess(null, null, null, 1, request, model);
    }

    @RequestMapping(value={"/log/o_delete_login_failure.do"})
    public String deleteLoginFailure(String queryTitle, String queryIp, Integer[] ids, Integer pageNo, HttpServletRequest request, ModelMap model) {
        CmsLog[] beans;
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        CmsLog[] cmsLogArray = beans = this.manager.deleteByIds(ids);
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            CmsLog bean = cmsLogArray[n2];
            log.info("delete CmsLog id={}", (Object)bean.getId());
            ++n2;
        }
        return this.listLoginFailure(queryTitle, queryIp, pageNo, request, model);
    }

    @RequestMapping(value={"/log/o_delete_login_failure_batch.do"})
    public String deleteLoginFailureBatch(Integer days, HttpServletRequest request, ModelMap model) {
        if (days == null) {
            days = 0;
        }
        this.manager.deleteBatch(2, null, days);
        model.addAttribute("message", (Object)"global.success");
        return this.listLoginFailure(null, null, 1, request, model);
    }

    private WebErrors validateDelete(Integer[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        if (errors.ifEmpty(ids, "ids")) {
            return errors;
        }
        Integer[] integerArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Integer id = integerArray[n2];
            this.vldExist(id, site.getId(), errors);
            ++n2;
        }
        return errors;
    }

    private boolean vldExist(Integer id, Integer siteId, WebErrors errors) {
        if (errors.ifNull(id, "id")) {
            return true;
        }
        CmsLog entity = this.manager.findById(id);
        return errors.ifNotExist(entity, CmsLog.class, id);
    }
}

