/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.admin.main;

import com.jeecms.cms.entity.main.CmsGroup;
import com.jeecms.cms.entity.main.CmsUser;
import com.jeecms.cms.entity.main.CmsUserExt;
import com.jeecms.cms.manager.main.CmsGroupMng;
import com.jeecms.cms.manager.main.CmsLogMng;
import com.jeecms.cms.manager.main.CmsUserMng;
import com.jeecms.cms.web.WebErrors;
import com.jeecms.common.page.Pagination;
import com.jeecms.common.page.SimplePage;
import com.jeecms.common.web.CookieUtils;
import com.jeecms.common.web.RequestUtils;
import com.jeecms.common.web.ResponseUtils;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class CmsMemberAct {
    private static final Logger log = LoggerFactory.getLogger(CmsMemberAct.class);
    @Autowired
    private CmsGroupMng cmsGroupMng;
    @Autowired
    private CmsLogMng cmsLogMng;
    @Autowired
    private CmsUserMng manager;

    @RequestMapping(value={"/member/v_list.do"})
    public String list(String queryUsername, String queryEmail, Integer queryGroupId, Boolean queryDisabled, Integer pageNo, HttpServletRequest request, ModelMap model) {
        Pagination pagination = this.manager.getPage(queryUsername, queryEmail, null, queryGroupId, queryDisabled, false, null, SimplePage.cpn((Integer)pageNo), CookieUtils.getPageSize((HttpServletRequest)request));
        model.addAttribute("pagination", (Object)pagination);
        model.addAttribute("queryUsername", (Object)queryUsername);
        model.addAttribute("queryEmail", (Object)queryEmail);
        model.addAttribute("queryGroupId", (Object)queryGroupId);
        model.addAttribute("queryDisabled", (Object)queryDisabled);
        return "member/list";
    }

    @RequestMapping(value={"/member/v_add.do"})
    public String add(ModelMap model) {
        List<CmsGroup> groupList = this.cmsGroupMng.getList();
        model.addAttribute("groupList", groupList);
        return "member/add";
    }

    @RequestMapping(value={"/member/v_edit.do"})
    public String edit(Integer id, Integer queryGroupId, Boolean queryDisabled, HttpServletRequest request, ModelMap model) {
        String queryUsername = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"queryUsername");
        String queryEmail = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"queryEmail");
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        List<CmsGroup> groupList = this.cmsGroupMng.getList();
        model.addAttribute("queryUsername", (Object)queryUsername);
        model.addAttribute("queryEmail", (Object)queryEmail);
        model.addAttribute("queryGroupId", (Object)queryGroupId);
        model.addAttribute("queryDisabled", (Object)queryDisabled);
        model.addAttribute("groupList", groupList);
        model.addAttribute("cmsMember", (Object)this.manager.findById(id));
        return "member/edit";
    }

    @RequestMapping(value={"/member/o_save.do"})
    public String save(CmsUser bean, CmsUserExt ext, String username, String email, String password, Integer groupId, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateSave(bean, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        String ip = RequestUtils.getIpAddr((HttpServletRequest)request);
        bean = this.manager.registerMember(username, email, password, ip, groupId, ext);
        log.info("save CmsMember id={}", (Object)bean.getId());
        this.cmsLogMng.operating(request, "cmsMember.log.save", "id=" + bean.getId() + ";username=" + bean.getUsername());
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/member/o_update.do"})
    public String update(Integer id, String email, String password, Boolean disabled, CmsUserExt ext, Integer groupId, String queryUsername, String queryEmail, Integer queryGroupId, Boolean queryDisabled, Integer pageNo, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateUpdate(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        CmsUser bean = this.manager.updateMember(id, email, password, disabled, ext, groupId);
        log.info("update CmsMember id={}.", (Object)bean.getId());
        this.cmsLogMng.operating(request, "cmsMember.log.update", "id=" + bean.getId() + ";username=" + bean.getUsername());
        return this.list(queryUsername, queryEmail, queryGroupId, queryDisabled, pageNo, request, model);
    }

    @RequestMapping(value={"/member/o_delete.do"})
    public String delete(Integer[] ids, Integer queryGroupId, Boolean queryDisabled, Integer pageNo, HttpServletRequest request, ModelMap model) {
        CmsUser[] beans;
        String queryUsername = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"queryUsername");
        String queryEmail = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"queryEmail");
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        CmsUser[] cmsUserArray = beans = this.manager.deleteByIds(ids);
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            CmsUser bean = cmsUserArray[n2];
            log.info("delete CmsMember id={}", (Object)bean.getId());
            this.cmsLogMng.operating(request, "cmsMember.log.delete", "id=" + bean.getId() + ";username=" + bean.getUsername());
            ++n2;
        }
        return this.list(queryUsername, queryEmail, queryGroupId, queryDisabled, pageNo, request, model);
    }

    @RequestMapping(value={"/member/v_check_username.do"})
    public void checkUsername(String username, HttpServletResponse response) {
        String pass = StringUtils.isBlank((String)username) ? "false" : (this.manager.usernameNotExist(username) ? "true" : "false");
        ResponseUtils.renderJson((HttpServletResponse)response, (String)pass);
    }

    private WebErrors validateSave(CmsUser bean, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        return errors;
    }

    private WebErrors validateEdit(Integer id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        if (this.vldExist(id, errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateUpdate(Integer id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        if (this.vldExist(id, errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateDelete(Integer[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        errors.ifEmpty(ids, "ids");
        Integer[] integerArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Integer id = integerArray[n2];
            this.vldExist(id, errors);
            ++n2;
        }
        return errors;
    }

    private boolean vldExist(Integer id, WebErrors errors) {
        if (errors.ifNull(id, "id")) {
            return true;
        }
        CmsUser entity = this.manager.findById(id);
        return errors.ifNotExist(entity, CmsUser.class, id);
    }
}

