/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.admin.main;

import com.jeecms.cms.entity.main.CmsModel;
import com.jeecms.cms.manager.main.CmsLogMng;
import com.jeecms.cms.manager.main.CmsModelMng;
import com.jeecms.cms.web.WebErrors;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class CmsModelAct {
    private static final Logger log = LoggerFactory.getLogger(CmsModelAct.class);
    @Autowired
    private CmsLogMng cmsLogMng;
    @Autowired
    private CmsModelMng manager;

    @RequestMapping(value={"/model/v_list.do"})
    public String list(HttpServletRequest request, ModelMap model) {
        List<CmsModel> list = this.manager.getList(true);
        model.addAttribute("list", list);
        return "model/list";
    }

    @RequestMapping(value={"/model/v_add.do"})
    public String add(ModelMap model) {
        return "model/add";
    }

    @RequestMapping(value={"/model/v_edit.do"})
    public String edit(Integer id, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        model.addAttribute("cmsModel", (Object)this.manager.findById(id));
        return "model/edit";
    }

    @RequestMapping(value={"/model/o_save.do"})
    public String save(CmsModel bean, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateSave(bean, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.save(bean);
        log.info("save CmsModel id={}", (Object)bean.getId());
        this.cmsLogMng.operating(request, "cmsModel.log.save", "id=" + bean.getId() + ";name=" + bean.getName());
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/model/o_update.do"})
    public String update(CmsModel bean, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateUpdate(bean.getId(), request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.update(bean);
        log.info("update CmsModel id={}.", (Object)bean.getId());
        this.cmsLogMng.operating(request, "cmsModel.log.update", "id=" + bean.getId() + ";name=" + bean.getName());
        return this.list(request, model);
    }

    @RequestMapping(value={"/model/o_delete.do"})
    public String delete(Integer[] ids, HttpServletRequest request, ModelMap model) {
        CmsModel[] beans;
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        CmsModel[] cmsModelArray = beans = this.manager.deleteByIds(ids);
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            CmsModel bean = cmsModelArray[n2];
            log.info("delete CmsModel id={}", (Object)bean.getId());
            this.cmsLogMng.operating(request, "cmsModel.log.delete", "id=" + bean.getId() + ";name=" + bean.getName());
            ++n2;
        }
        return this.list(request, model);
    }

    @RequestMapping(value={"/model/o_priority.do"})
    public String priority(Integer[] wids, Integer[] priority, Boolean[] disabled, Integer defId, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validatePriority(wids, priority, disabled, defId, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        this.manager.updatePriority(wids, priority, disabled, defId);
        model.addAttribute("message", (Object)"global.success");
        return this.list(request, model);
    }

    private WebErrors validateSave(CmsModel bean, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        return errors;
    }

    private WebErrors validateEdit(Integer id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        if (this.vldExist(id, errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateUpdate(Integer id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        if (this.vldExist(id, errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateDelete(Integer[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        errors.ifEmpty(ids, "ids");
        Integer[] integerArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Integer id = integerArray[n2];
            this.vldExist(id, errors);
            ++n2;
        }
        return errors;
    }

    private WebErrors validatePriority(Integer[] wids, Integer[] priority, Boolean[] disabled, Integer defId, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        if (errors.ifEmpty(wids, "wids")) {
            return errors;
        }
        if (errors.ifEmpty(priority, "priority")) {
            return errors;
        }
        if (wids.length != priority.length || wids.length != disabled.length) {
            String s = "wids length not equals priority length or disabled length";
            errors.addErrorString(s);
            return errors;
        }
        int i = 0;
        int len = wids.length;
        while (i < len) {
            if (this.vldExist(wids[i], errors)) {
                return errors;
            }
            if (priority[i] == null) {
                priority[i] = 0;
            }
            if (disabled[i] == null) {
                disabled[i] = false;
            }
            ++i;
        }
        if (this.vldExist(defId, errors)) {
            return errors;
        }
        return errors;
    }

    private boolean vldExist(Integer id, WebErrors errors) {
        if (errors.ifNull(id, "id")) {
            return true;
        }
        CmsModel entity = this.manager.findById(id);
        return errors.ifNotExist(entity, CmsModel.class, id);
    }
}

